// Generated by delombok at Mon Sep 30 19:32:36 UTC 2024
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.ErrorCode;
import gov.cms.fiss.pricers.ltch.core.codes.PaymentType;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateChargeThreshold implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CalculateChargeThreshold.class);

  /**
   * <pre>
   * ***************************************************************
   * *   CALCULATE CHARGE THRESHOLD &amp; SET ERROR RTC WHEN APPLICABLE*
   * ***************************************************************
   * </pre>
   *
   * Converted from {@code 6100-CALC-CHARGE-THRESHOLD} in the COBOL code.
   */
  @Override
  public void calculate(LtchPricerContext calculationContext) {
    final LtchPaymentData paymentData = calculationContext.getPaymentData();
    final PaymentType paymentType = calculationContext.getPaymentType();
    final LtchClaimData claimData = calculationContext.getClaimData();
    final InpatientProviderData providerData = calculationContext.getProviderData();
    final BigDecimal coveredDays = new BigDecimal(claimData.getCoveredDays());
    // IF (PPS-OUTLIER-PAY-AMT > 0 AND
    //     NOT (PMT-BLEND AND H-OUTLIER-PAY-AMT-SNT = 0)) OR
    //    PPS-COT-IND = 'Y'
    if (isOutlierAndSuccessful(calculationContext) && isNonBlendNonSiteNeutralOutlierPaymentOrChangeOfTherapy(calculationContext, paymentData, paymentType)) {
      // IF B-COV-DAYS < H-LOS OR
      //    (PPS-COT-IND = 'Y' AND P-NEW-OPER-CSTCHG-RATIO NOT = 0)
      if (BigDecimalUtils.isLessThan(coveredDays, calculationContext.getHoldLengthOfStay()) || "Y".equals(paymentData.getChangeOfTherapyIndicator()) && !BigDecimalUtils.isZero(providerData.getOperatingCostToChargeRatio())) {
        // COMPUTE PPS-CHRG-THRESHOLD ROUNDED =
        //             PPS-OUTLIER-THRESHOLD / P-NEW-OPER-CSTCHG-RATIO
        paymentData.setChargeThresholdAmount(paymentData.getOutlierThresholdAmount().divide(providerData.getOperatingCostToChargeRatio(), RoundingMode.HALF_UP));
        if (Boolean.TRUE.equals(calculationContext.getPcPricer())) {
          calculationContext.applyReturnCode(ReturnCode.COST_OUTLIER_WITH_LOS_LT_COV_DAYS_67);
        }
      }
    }
    // setting to true for second loop through which happens regardless of payment type
    calculationContext.setCalculateOutliers(true);
  }

  private boolean isNonBlendNonSiteNeutralOutlierPaymentOrChangeOfTherapy(LtchPricerContext calculationContext, LtchPaymentData paymentData, PaymentType paymentType) {
    // IF (PPS-OUTLIER-PAY-AMT > 0 AND
    //    NOT (PMT-BLEND AND H-OUTLIER-PAY-AMT-SNT = 0)) OR
    //   PPS-COT-IND = 'Y'
    return BigDecimalUtils.isGreaterThanZero(paymentData.getOutlierPayment()) && !(paymentType.equals(PaymentType.BLEND) && BigDecimalUtils.isZero(calculationContext.getHoldOutlierPayAmountSiteNeutral())) || "Y".equals(paymentData.getChangeOfTherapyIndicator());
  }

  private boolean isOutlierAndSuccessful(LtchPricerContext calculationContext) {
    return calculationContext.getCalculateOutliers() && !ErrorCode.isErrorCode(calculationContext.getReturnCode());
  }
}
