// Generated by delombok at Mon Sep 30 19:32:36 UTC 2024
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeSiteNeutral;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateSiteNeutralPayment implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CalculateSiteNeutralPayment.class);

  @Override
  public boolean shouldExecute(LtchPricerContext calculationContext) {
    return calculationContext.isPaymentBlendOrSiteNeutral();
  }

  @Override
  public void calculate(LtchPricerContext calculationContext) {
    final LtchPaymentData paymentData = calculationContext.getPaymentData();
    // *-------------------------------------------------------------*
    // * CALCULATE SITE NEUTRAL IPPS COMP. PMT HIGH COST OUTLIER     *
    // * (HCO) FOR THE MINIMUM PAYMENT COMPARISON                    *
    // *-------------------------------------------------------------*
    // COMPUTE PPS-OUTLIER-PAY-AMT ROUNDED =
    //         PPS-OUTLIER-PAY-AMT *
    //         H-SITE-NEUTRAL-IPPS-ADJ.
    paymentData.setOutlierPayment(paymentData.getOutlierPayment().multiply(calculationContext.getHoldSiteNeutralIppsAdj()));
    calculationContext.setHoldOutlierIppsComparable(paymentData.getOutlierPayment());
    paymentData.setSiteNeutralIppsPayment(BigDecimal.ZERO);
    paymentData.setOutlierPayment(BigDecimal.ZERO);
    calculationContext.setHoldOutlierIppsComparable(paymentData.getOutlierPayment());
    // *-------------------------------------------------------------*
    // * CALCULATE THE SITE NEUTRAL PAYMENT USING THE FOLLOWING      *
    // * FORMULA FROM POLICY GROUP:                                  *
    // * MIN ( SN ADJ * (IPPS PER DIEM AMT + SN IPPS HCO) , COST)    *
    // *-------------------------------------------------------------*
    // *-------------------------------------------------------------*
    // * CALCULATE SITE NEUTRAL COST PAYMENT FOR MIN PMT COMPARISON  *
    // *-------------------------------------------------------------*
    calculationContext.setHoldSnCostComparison(paymentData.getFacilityCosts());
    // *-------------------------------------------------------------*
    // * CALCULATE SITE NEUTRAL IPPS COMP PMT FOR MIN PMT COMPARISON *
    // *-------------------------------------------------------------*
    // COMPUTE H-SN-IPPS-4COMPARISON ROUNDED =
    //         H-SITE-NEUTRAL-IPPS-ADJ *
    //         (H-IPPS-PER-DIEM +
    //         H-OUTLIER-IPPS-COMPARABLE).
    calculationContext.setHoldSnIppsComparison(calculationContext.getHoldIppsPerDiem().add(calculationContext.getHoldOutlierIppsComparable()).multiply(calculationContext.getHoldSiteNeutralIppsAdj()).setScale(2, RoundingMode.HALF_UP));
    // *-------------------------------------------------------------*
    // * MINIMUM IS FINAL SITE NEUTRAL PMT BASED ON COST             *
    // *-------------------------------------------------------------*
    // IF H-SN-COST-4COMPARISON < H-SN-IPPS-4COMPARISON
    if (BigDecimalUtils.isLessThan(calculationContext.getHoldSnCostComparison(), calculationContext.getHoldSnIppsComparison())) {
      calculationContext.setSecondaryPaymentTypeSiteNeutral(SecondaryPaymentTypeSiteNeutral.COST);
      paymentData.setSiteNeutralCostPayment(paymentData.getFacilityCosts());
    } else {
      // *-------------------------------------------------------------*
      // * MINIMUM IS FINAL SITE-NEUTRAL PMT BASED ON IPPS COMPARABLE  *
      // *-------------------------------------------------------------*
      calculationContext.setSecondaryPaymentTypeSiteNeutral(SecondaryPaymentTypeSiteNeutral.IPPS);
      paymentData.setSiteNeutralIppsPayment(calculationContext.getHoldIppsPerDiem());
    }
  }
}
