// Generated by delombok at Mon Sep 30 19:32:36 UTC 2024
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.PaymentType;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import java.math.RoundingMode;

public class CleanupShortStay implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CleanupShortStay.class);

  @Override
  public boolean shouldExecute(LtchPricerContext calculationContext) {
    return calculationContext.isPaymentStandardOrBlend() && BigDecimalUtils.isLessThanOrEqualTo(calculationContext.getHoldLengthOfStay(), calculationContext.getHoldShortStayOutlierThreshold());
  }

  @Override
  public void calculate(LtchPricerContext calculationContext) {
    final PaymentType paymentType = calculationContext.getPaymentType();
    final LtchPaymentData paymentData = calculationContext.getPaymentData();
    // IF H-LOS <= H-SSOT
    // IF PMT-STANDARD-NEW OR PMT-BLEND
    paymentData.setAdjustedPayment(calculationContext.getHoldShortStayBlendedPayment().setScale(2, RoundingMode.HALF_UP));
    if (paymentType.equals(PaymentType.STANDARD_OLD)) {
      calculationContext.applyReturnCode(ReturnCode.SHORT_STAY_BASED_ON_LTC_DRG_AND_IPPS_COMP_22);
    }
    calculationContext.setHoldShortStayBlendIndicator("Y");
    calculationContext.setHoldShortStayCostIndicator("N");
    calculationContext.setHoldShortStayPerDiemIndicator("N");
    calculationContext.setHoldShortStayIppsCompIndicator("N");
  }
}
