// Generated by delombok at Mon Sep 30 19:32:36 UTC 2024
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CleanupShortStayBlendedPayment implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CleanupShortStayBlendedPayment.class);

  @Override
  public boolean shouldExecute(LtchPricerContext calculationContext) {
    return calculationContext.isPaymentStandardOrBlend() && BigDecimalUtils.isLessThanOrEqualTo(calculationContext.getHoldLengthOfStay(), calculationContext.getHoldShortStayOutlierThreshold());
  }

  @Override
  public void calculate(LtchPricerContext calculationContext) {
    // *** ------------------------------------------------------ ***
    // *** CALCULATE THE BLEND PERCENTAGE OF IPPS COMPARABLE PMT  ***
    // *** ------------------------------------------------------ ***
    // COMPUTE H-IPPS-BLEND-PCT ROUNDED =
    //         1 - H-LTCH-BLEND-PCT.
    calculationContext.setHoldIppsBlendPercentage(BigDecimal.ONE.subtract(calculationContext.getHoldLtchBlendPercentage()).setScale(4, RoundingMode.HALF_UP));
    // *** ------------------------------------------------------ ***
    // *** CALCULATE THE BLEND AMOUNT OF IPPS COMPARABLE PMT      ***
    // *** ------------------------------------------------------ ***
    // COMPUTE H-IPPS-BLEND-AMT ROUNDED =
    //         H-IPPS-PER-DIEM * H-IPPS-BLEND-PCT
    calculationContext.setHoldIppsBlendAmount(calculationContext.getHoldIppsPerDiem().multiply(calculationContext.getHoldIppsBlendPercentage()).setScale(2, RoundingMode.HALF_UP));
    // *** ------------------------------------------------------ ***
    // *** CALCULATE THE SHORT STAY BLENDED PAYMENT ALTERNATIVE   ***
    // *** ------------------------------------------------------ ***
    // COMPUTE H-SS-BLENDED-PMT ROUNDED =
    //         H-LTCH-BLEND-AMT + H-IPPS-BLEND-AMT.
    calculationContext.setHoldShortStayBlendedPayment(calculationContext.getHoldLtchBlendAmount().add(calculationContext.getHoldIppsBlendAmount()).setScale(2, RoundingMode.HALF_UP));
  }
}
