// Generated by delombok at Mon Sep 30 19:32:36 UTC 2024
package gov.cms.fiss.pricers.ltch.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.LtchPricerContext;
import gov.cms.fiss.pricers.ltch.core.codes.PaymentType;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeStandard;
import java.math.RoundingMode;

public class CleanupStandardPayment implements CalculationRule<LtchClaimPricingRequest, LtchClaimPricingResponse, LtchPricerContext> {
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  private static final org.slf4j.Logger log = org.slf4j.LoggerFactory.getLogger(CleanupStandardPayment.class);

  @Override
  public boolean shouldExecute(LtchPricerContext calculationContext) {
    final PaymentType paymentType = calculationContext.getPaymentType();
    return calculationContext.isPaymentStandardOrBlend() && !BigDecimalUtils.isLessThanOrEqualTo(calculationContext.getHoldLengthOfStay(), calculationContext.getHoldShortStayOutlierThreshold()) && (paymentType.equals(PaymentType.STANDARD_NEW) || paymentType.equals(PaymentType.BLEND));
  }

  @Override
  public void calculate(LtchPricerContext calculationContext) {
    final LtchPaymentData paymentData = calculationContext.getPaymentData();
    // *-------------------------------------------------------------*
    // * FOR REGULAR STAY CLAIMS, POPULATE THE APPROPRIATE PAYMENT   *
    // * FIELD FOR NEW POLICY CLAIMS                                 *
    // *-------------------------------------------------------------*
    calculationContext.setSecondaryPaymentTypeStandard(SecondaryPaymentTypeStandard.FULL);
    paymentData.setStandardFullPayment(paymentData.getAdjustedPayment().setScale(2, RoundingMode.HALF_UP));
  }
}
