// Generated by delombok at Mon Sep 30 19:32:36 UTC 2024
package gov.cms.fiss.pricers.ltch.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.ltch.LtchPricerConfiguration;
import gov.cms.fiss.pricers.ltch.api.v1.InpatientDrgsTableEntry;
import gov.cms.fiss.pricers.ltch.api.v1.LtchDrgsTableEntry;
import java.time.LocalDate;
import java.util.Map;
import java.util.Map.Entry;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

/**
 * This class is responsible for holding all the CopyBook data tables for the pricer as well as
 * helper methods to access the data.
 */
public class DataTables {
  private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<>();
  private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
  private final Map<String, NavigableMap<LocalDate, WageIppsIndexRuralEntry>> wageIppsIndexRuralMap;
  private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> ippsCbsaTable;
  private final Map<String, NavigableMap<LocalDate, InpatientDrgsTableEntry>> ippsDrgsMap;
  private final Map<String, LtchDrgsTableEntry> ltchDrgsMap;

  public DataTables(Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable, Map<String, NavigableMap<LocalDate, WageIppsIndexRuralEntry>> wageIppsIndexRuralMap, Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> ippsCbsaTable, Map<String, NavigableMap<LocalDate, InpatientDrgsTableEntry>> ippsDrgsMap, Map<String, LtchDrgsTableEntry> ltchDrgsMap) {
    this.cbsaTable = cbsaTable;
    this.wageIppsIndexRuralMap = wageIppsIndexRuralMap;
    this.ippsCbsaTable = ippsCbsaTable;
    this.ippsDrgsMap = ippsDrgsMap;
    this.ltchDrgsMap = ltchDrgsMap;
  }

  public static DataTables forYear(int pricerYear) {
    return YEAR_LOOKUP.get(pricerYear);
  }

  /**
   * Loads data tables with the given CSV ingestion configuration.
   */
  public static void loadDataTables(LtchPricerConfiguration pricerConfiguration) {
    final CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
    final CbsaWageIndexLookupGenerator cbsaTableLookupGenerator = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
    final WageIppsIndexRuralLookupGenerator wageIppsIndexRuralLookupGenerator = new WageIppsIndexRuralLookupGenerator(csvIngestionConfiguration);
    final IppsCbsaWageIndexLookupGenerator ippsCbsaWageIndexLookupGenerator = new IppsCbsaWageIndexLookupGenerator(csvIngestionConfiguration);
    final InpatientDrgsTableLookupGenerator inpatientDrgsTableLookupGenerator = new InpatientDrgsTableLookupGenerator();
    final LtchDrgsTableLookupGenerator ltchDrgsTableLookupGenerator = new LtchDrgsTableLookupGenerator();
    // Load all the tables
    for (final int pricerYear : pricerConfiguration.getSupportedYears()) {
      final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaMap = cbsaTableLookupGenerator.generate(pricerYear);
      final Map<String, NavigableMap<LocalDate, WageIppsIndexRuralEntry>> wageIppsIndexRuralMap = wageIppsIndexRuralLookupGenerator.generate();
      final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> ippsCbsaMap = ippsCbsaWageIndexLookupGenerator.generate(pricerYear);
      final Map<String, NavigableMap<LocalDate, InpatientDrgsTableEntry>> ippsDrgsMap = inpatientDrgsTableLookupGenerator.generate(pricerYear);
      final Map<String, LtchDrgsTableEntry> ltchDrgsMap = ltchDrgsTableLookupGenerator.generate(pricerYear);
      YEAR_LOOKUP.put(pricerYear, new DataTables(cbsaMap, wageIppsIndexRuralMap, ippsCbsaMap, ippsDrgsMap, ltchDrgsMap));
    }
  }

  public WageIppsIndexRuralEntry getWageIppsIndexRural(String cbsa, LocalDate effectiveDate) {
    if (cbsa == null) {
      return null;
    }
    final NavigableMap<LocalDate, WageIppsIndexRuralEntry> entries = this.wageIppsIndexRuralMap.get(cbsa.trim());
    return getEntry(effectiveDate, entries);
  }

  public CbsaWageIndexEntry getCbsaWageIndexEntry(String cbsa, LocalDate effectiveDate) {
    final NavigableMap<LocalDate, CbsaWageIndexEntry> entries = this.cbsaTable.get(cbsa);
    return getEntry(effectiveDate, entries);
  }

  public CbsaWageIndexEntry getIppsCbsaWageIndex(String cbsa, LocalDate effectiveDate) {
    if (cbsa == null) {
      return null;
    }
    final NavigableMap<LocalDate, CbsaWageIndexEntry> entries = this.ippsCbsaTable.get(cbsa.trim());
    return getEntry(effectiveDate, entries);
  }

  private static <T> T getEntry(LocalDate effectiveDate, NavigableMap<LocalDate, T> map) {
    if (map == null) {
      return null;
    }
    final Entry<LocalDate, T> floorEntry = map.floorEntry(effectiveDate);
    if (floorEntry == null) {
      return null;
    } else {
      return floorEntry.getValue();
    }
  }

  public InpatientDrgsTableEntry getInpatientDrgEntry(String code, LocalDate effectiveDate) {
    final NavigableMap<LocalDate, InpatientDrgsTableEntry> entries = ippsDrgsMap.get(StringUtils.leftPad(code, 3, "0"));
    if (entries != null) {
      final Entry<LocalDate, InpatientDrgsTableEntry> entry = entries.floorEntry(effectiveDate);
      return null == entry ? null : entry.getValue();
    }
    return null;
  }

  public LtchDrgsTableEntry getLtchDrgsEntry(String code) {
    return ltchDrgsMap.get(code);
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
    return this.cbsaTable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, NavigableMap<LocalDate, InpatientDrgsTableEntry>> getIppsDrgsMap() {
    return this.ippsDrgsMap;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, LtchDrgsTableEntry> getLtchDrgsMap() {
    return this.ltchDrgsMap;
  }
}
