// Generated by delombok at Mon Sep 30 19:32:36 UTC 2024
package gov.cms.fiss.pricers.ltch.core.tables;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonFormat.Shape;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.core.tables.WageIppsIndexRuralEntry.Fields;
import java.math.BigDecimal;
import java.time.LocalDate;
import javax.annotation.concurrent.Immutable;
import javax.validation.constraints.Digits;
import org.apache.commons.lang3.StringUtils;

@Immutable
@JsonDeserialize(builder = WageIppsIndexRuralEntry.WageIppsIndexRuralEntryBuilder.class)
@JsonPropertyOrder({Fields.CBSA, Fields.EFFECTIVE_DATE, Fields.WAGE_INDEX})
public class WageIppsIndexRuralEntry {

  @JsonPOJOBuilder(withPrefix = "")
  public static class WageIppsIndexRuralEntryBuilder {
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private String cbsa;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private LocalDate effectiveDate;
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BigDecimal wageIndex;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    WageIppsIndexRuralEntryBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WageIppsIndexRuralEntry.WageIppsIndexRuralEntryBuilder cbsa(final String cbsa) {
      this.cbsa = cbsa;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @JsonFormat(shape = Shape.STRING, pattern = "yyyyMMdd")
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WageIppsIndexRuralEntry.WageIppsIndexRuralEntryBuilder effectiveDate(final LocalDate effectiveDate) {
      this.effectiveDate = effectiveDate;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WageIppsIndexRuralEntry.WageIppsIndexRuralEntryBuilder wageIndex(final BigDecimal wageIndex) {
      this.wageIndex = wageIndex;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public WageIppsIndexRuralEntry build() {
      return new WageIppsIndexRuralEntry(this.cbsa, this.effectiveDate, this.wageIndex);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "WageIppsIndexRuralEntry.WageIppsIndexRuralEntryBuilder(cbsa=" + this.cbsa + ", effectiveDate=" + this.effectiveDate + ", wageIndex=" + this.wageIndex + ")";
    }
  }

  private final String cbsa;
  @JsonFormat(shape = Shape.STRING, pattern = "yyyyMMdd")
  private final LocalDate effectiveDate;
  @Digits(integer = 2, fraction = 4)
  private final BigDecimal wageIndex;

  @JsonIgnore
  public String getCbsaPadded() {
    return StringUtils.leftPad(cbsa, 5, ' ');
  }

  public WageIppsIndexRuralEntryBuilder copyBuilder() {
    return WageIppsIndexRuralEntry.builder().cbsa(getCbsa()).effectiveDate(getEffectiveDate()).wageIndex(getWageIndex());
  }

  public static final WageIppsIndexRuralEntryBuilder DEFAULT = WageIppsIndexRuralEntry.builder().cbsa("   00").wageIndex(BigDecimalUtils.ZERO);

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  WageIppsIndexRuralEntry(final String cbsa, final LocalDate effectiveDate, final BigDecimal wageIndex) {
    this.cbsa = cbsa;
    this.effectiveDate = effectiveDate;
    this.wageIndex = wageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static WageIppsIndexRuralEntry.WageIppsIndexRuralEntryBuilder builder() {
    return new WageIppsIndexRuralEntry.WageIppsIndexRuralEntryBuilder();
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCbsa() {
    return this.cbsa;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getEffectiveDate() {
    return this.effectiveDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getWageIndex() {
    return this.wageIndex;
  }


  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public static final class Fields {
    public static final java.lang.String CBSA = "cbsa";
    public static final java.lang.String EFFECTIVE_DATE = "effectiveDate";
    public static final java.lang.String WAGE_INDEX = "wageIndex";
  }
}
