// Generated by delombok at Mon Sep 30 19:32:36 UTC 2024
package gov.cms.fiss.pricers.ltch.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.api.ReturnCodeData;
import gov.cms.fiss.pricers.common.api.annotations.FixedValue;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimData;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingRequest;
import gov.cms.fiss.pricers.ltch.api.v2.LtchClaimPricingResponse;
import gov.cms.fiss.pricers.ltch.api.v2.LtchPaymentData;
import gov.cms.fiss.pricers.ltch.core.codes.CbsaProviderType;
import gov.cms.fiss.pricers.ltch.core.codes.PaymentType;
import gov.cms.fiss.pricers.ltch.core.codes.ReturnCode;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeSiteNeutral;
import gov.cms.fiss.pricers.ltch.core.codes.SecondaryPaymentTypeStandard;
import gov.cms.fiss.pricers.ltch.core.models.LtchWageIndexTableEntry;
import gov.cms.fiss.pricers.ltch.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.ltch.core.tables.DataTables;
import gov.cms.fiss.pricers.ltch.core.tables.WageIppsIndexRuralEntry;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public abstract class LtchPricerContext extends CalculationContext<LtchClaimPricingRequest, LtchClaimPricingResponse> {
  private static final EnumSet<PaymentType> STANDARD_OR_BLEND_TYPES = EnumSet.of(PaymentType.STANDARD_NEW, PaymentType.STANDARD_OLD, PaymentType.BLEND);
  private static final EnumSet<PaymentType> STANDARD_NEW_SITE_NEUTRAL_OR_BLEND_TYPES = EnumSet.of(PaymentType.STANDARD_NEW, PaymentType.SITE_NEUTRAL, PaymentType.BLEND);
  private static final LocalDate PUBLIC_HEALTH_EMERGENCY_LAST_DAY = LocalDate.of(2023, 5, 11);
  private static final List<String> PSYCH_REHAB_DRUGS = Arrays.asList("876", "880", "881", "882", "883", "884", "885", "887", "886", "894", "895", "896", "897", "945", "946");
  @JsonIgnore
  private final DataTables dataTables;
  private WageIppsIndexRuralEntry wageIndexFloor = WageIppsIndexRuralEntry.DEFAULT.build();
  private LtchWageIndexTableEntry ltchWageIndexTableEntry = new LtchWageIndexTableEntry();
  @FixedValue
  private BigDecimal holdLaborPortionRounded; // H-LABOR-PORTION
  @FixedValue
  private BigDecimal holdNonLaborPortionRounded; // H-NONLABOR-PORTION
  @FixedValue
  private BigDecimal holdBudgetNeutralFactor = new BigDecimal("0.949").setScale(6, RoundingMode.HALF_UP); // H-BDGT-NEUT-FACTOR
  @FixedValue
  private BigDecimal holdSiteNeutralIppsAdj = new BigDecimal("0.954").setScale(6, RoundingMode.HALF_UP); // H-SITE-NEUTRAL-IPPS-ADJ
  private Boolean pcPricer = false;
  private Boolean ippsComparablePayment = false;
  private Boolean calculateOutliers = false;
  private String ventilationIcd10Code = "5A1955Z";
  protected String calculationVersion;
  BigDecimal holdLtchBlendPercentage;
  private PaymentType paymentType;
  private CbsaWageIndexEntry ruralWageIndexFloor;
  private CbsaWageIndexEntry imputedWageIndexFloor;
  private LocalDate fyBegin;
  private LocalDate fyEnd;
  private LtchPaymentData paymentData;
  private WageIppsIndexRuralEntry holdProvIppsCbsaRural; // HOLD-PROV-IPPS-CBSA-RURALcalculationContext.getHoldProvIppsCbsaRural()
  private CbsaWageIndexEntry holdProvIppsCBSA; // HOLD-PROV-IPPS-CBSA
  private BigDecimal holdCapitalTeachingAdjustmentRatio; // H-CAPI-IME-RATIO
  private BigDecimal holdOperatingDshPercent; // H-OPER-DSH-PCT
  private BigDecimal holdBedSize; // H-BED-SIZE
  private BigDecimal holdOperatingDshAmount; // H-OPER-DSH
  private BigDecimal holdIppsWageIndex; // H-IPPS-WAGE-INDEX
  @FixedValue
  private BigDecimal holdIppsNationalLaborShare; // H-IPPS-NAT-LABOR-SHR
  private BigDecimal holdStandardAmountOperatingPayment; // H-STAND-AMT-OPER-PMT
  private BigDecimal holdIppsNationalNonLaborShare; // H-IPPS-NAT-NONLABOR-SHR
  private BigDecimal holdIppsDrgWeight; // H-IPPS-DRG-WGT
  private BigDecimal holdCapitalCola; // H-CAPI-COLA
  private BigDecimal holdCapitalGeographicAreaFactor; // H-CAPI-GAF
  private BigDecimal holdCapitalPayment; // H-CAPI-PMT
  private BigDecimal holdCapitalImeTeach; // H-CAPI-IME-TEACH
  private BigDecimal holdCapitalDsh; // H-CAPI-DSH
  private BigDecimal holdIppsPayAmount; // H-IPPS-PAY-AMT
  private BigDecimal holdIppsDrgALengthOfStay; // H-IPPS-DRG-ALOS
  private BigDecimal holdIppsArithALengthOfStay; // H-IPPS-ARITH-ALOS
  private BigDecimal holdLengthOfStay; // H-LOS
  private BigDecimal holdIppsPerDiem; // H-IPPS-PER-DIEM
  private BigDecimal holdShortStayOutlierThreshold; // H-SSOT
  private BigDecimal holdLtchBlendAmount; // H-LTCH-BLEND-AMT
  private BigDecimal holdShortStayPayAmount; // H-SS-PAY-AMT
  private BigDecimal holdIppsBlendPercentage; // H-IPPS-BLEND-PCT
  private BigDecimal holdIppsBlendAmount; // H-IPPS-BLEND-AMT
  private BigDecimal holdShortStayBlendedPayment; // H-SS-BLENDED-PMT
  private BigDecimal holdOutlierThresholdStandard; // H-OUTLIER-THRESHOLD-STD
  private BigDecimal holdOutlierPayAmountStandard = BigDecimal.ZERO; // H-OUTLIER-PAY-AMT-STD
  private BigDecimal holdOutlierPayAmountSiteNeutral = BigDecimal.ZERO; // H-OUTLIER-PAY-AMT-SNT
  private BigDecimal holdOutlierIppsComparable; // H-OUTLIER-IPPS-COMPARABLE
  private BigDecimal holdSnCostComparison; // H-SN-COST-4COMPARISON
  private BigDecimal holdSnIppsComparison; // H-SN-IPPS-4COMPARISON
  @FixedValue
  private BigDecimal holdBlendStandard; // H-BLEND-STD
  @FixedValue
  private BigDecimal holdBlendSiteNeutral; // H-BLEND-SNT
  private String holdShortStayBlendIndicator; // H-SS-BLEND-IND
  private String holdShortStayCostIndicator; // H-SS-COST-IND
  private String holdShortStayPerDiemIndicator; // H-SS-PERDIEM-IND
  private String holdShortStayIppsCompIndicator; // H-SS-IPPSCOMP-IND
  private BigDecimal holdBlendRtc; // H-BLEND-RTC
  private BigDecimal holdLargeUrbanAddon; // H-LRGURB-ADD-ON
  private int holdRegularDays; // H-REG-DAYS
  private int holdTotalDays; // H-TOTAL-DAYS
  private LocalDate holdAdmissionDate; // H-ADMISSION-DATE
  private LocalDate holdDischargeDate; // H-DISCHARGE-DATE
  private BigDecimal holdIPPSLikeAmt; // H-IPPS-LIKE-AMT
  private BigDecimal holdIPPSOutlier = BigDecimal.ZERO; // H-IPPS-LIKE-AMT-OUTLIER
  private BigDecimal holdPreDPPPay; // H-PRE-DPP-PAY
  private SecondaryPaymentTypeStandard secondaryPaymentTypeStandard;
  private SecondaryPaymentTypeSiteNeutral secondaryPaymentTypeSiteNeutral;
  private String returnCodePart1;
  private String returnCodePart2;

  protected LtchPricerContext(LtchClaimPricingRequest input, LtchClaimPricingResponse output, DataTables dataTables) {
    super(input, output);
    this.dataTables = dataTables;
    paymentData = getOutput().getPaymentData();
    initialize();
  }

  private void initialize() {
    getOutput().setReturnCodeData(new ReturnCodeData());
    getOutput().getReturnCodeData().setCode("00");
    getOutput().getPaymentData().setTotalPayment(BigDecimal.ZERO.setScale(2, RoundingMode.HALF_UP));
  }

  public LtchClaimData getClaimData() {
    return getInput().getClaimData();
  }

  public InpatientProviderData getProviderData() {
    return getInput().getProviderData();
  }

  public String getReturnCode() {
    return getOutput().getReturnCodeData().getCode();
  }

  public boolean isPsychRehabDrg() {
    return PSYCH_REHAB_DRUGS.contains(getPaymentData().getSubmittedDiagnosisRelatedGroup());
  }

  public void applyReturnCode(ReturnCode code) {
    getOutput().setReturnCodeData(code.toReturnCodeData());
  }

  public void applyReturnCodeFromTwoPartCode() {
    final ReturnCode code = ReturnCode.fromCode(returnCodePart1 + returnCodePart2);
    if (code != null) {
      applyReturnCode(code);
    }
  }

  public Integer getReviewCodeAsInt() {
    return Integer.parseInt(getClaimData().getReviewCode());
  }

  public boolean isSpecialPaymentIndicatorEmpty(String specialPaymentIndicator) {
    return StringUtils.isEmpty(specialPaymentIndicator) || "0".equals(specialPaymentIndicator);
  }

  public boolean isSpecialPaymentIndicatorSpecial(String specialPaymentIndicator) {
    return !isSpecialPaymentIndicatorEmpty(specialPaymentIndicator) && StringUtils.equalsAny(specialPaymentIndicator, "1", "2");
  }

  public boolean isPaymentBlendOrSiteNeutral() {
    return paymentType == PaymentType.BLEND || paymentType == PaymentType.SITE_NEUTRAL;
  }

  public boolean isPaymentStandardNewSiteNeutralOrBlendTypes() {
    return STANDARD_NEW_SITE_NEUTRAL_OR_BLEND_TYPES.contains(paymentType);
  }

  public boolean isPaymentStandardOrBlend() {
    return STANDARD_OR_BLEND_TYPES.contains(paymentType);
  }

  public LocalDate getPublicHealthEmergencyLastDay() {
    return PUBLIC_HEALTH_EMERGENCY_LAST_DAY;
  }

  public String getSupplementalWageIndexIndicator() {
    return getProviderData().getSupplementalWageIndexIndicator();
  }

  public BigDecimal getSupplementalWageIndex() {
    return getProviderData().getSupplementalWageIndex();
  }

  public CbsaProviderType getCbsaProviderType() {
    switch (getHoldProvIppsCBSA().getSize()) {
    default: 
      return CbsaProviderType.RURAL;
    default: 
      return CbsaProviderType.URBAN;
    }
  }

  @FixedValue
  public abstract BigDecimal getStandardQualityFedRate();

  @FixedValue
  public abstract BigDecimal getStandardFedRate();

  @FixedValue
  public abstract BigDecimal getNationalLaborPercent();

  @FixedValue
  public abstract BigDecimal getNationalNonLaborPercent();

  @FixedValue
  public abstract BigDecimal getHighIppsNationalLaborShare();

  @FixedValue
  public abstract BigDecimal getLowIppsNationalLaborShare();

  @FixedValue
  public abstract BigDecimal getHighIppsNationalNonLaborShare();

  @FixedValue
  public abstract BigDecimal getLowIppsNationalNonLaborShare();

  @FixedValue
  public abstract BigDecimal getFixedLossAmountStandard();

  @FixedValue
  public abstract BigDecimal getFixedLossAmountSiteNeutral();

  @FixedValue
  public abstract BigDecimal getOperatingDshReductionFactor();

  @FixedValue
  public abstract BigDecimal getIppsCapitalStandardFedRate();

  public boolean isStandardPaymentNew() {
    final LtchClaimData claimData = getClaimData();
    return StringUtils.equals(claimData.getReviewCode(), "01") && !isPsychRehabDrg() || StringUtils.equalsAny(claimData.getReviewCode(), "04", "05");
  }

  public void calculateIppsLaborShares() {
    CbsaWageIndexEntry entry = getHoldProvIppsCBSA();
    if (entry != null && BigDecimalUtils.isGreaterThan(entry.getGeographicWageIndex(), BigDecimal.ONE)) {
      setHoldIppsNationalLaborShare(getHighIppsNationalLaborShare());
      setHoldIppsNationalNonLaborShare(getHighIppsNationalNonLaborShare());
    } else {
      setHoldIppsNationalLaborShare(getLowIppsNationalLaborShare());
      setHoldIppsNationalNonLaborShare(getLowIppsNationalNonLaborShare());
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public DataTables getDataTables() {
    return this.dataTables;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public WageIppsIndexRuralEntry getWageIndexFloor() {
    return this.wageIndexFloor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LtchWageIndexTableEntry getLtchWageIndexTableEntry() {
    return this.ltchWageIndexTableEntry;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldLaborPortionRounded() {
    return this.holdLaborPortionRounded;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldNonLaborPortionRounded() {
    return this.holdNonLaborPortionRounded;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldBudgetNeutralFactor() {
    return this.holdBudgetNeutralFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldSiteNeutralIppsAdj() {
    return this.holdSiteNeutralIppsAdj;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getPcPricer() {
    return this.pcPricer;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getIppsComparablePayment() {
    return this.ippsComparablePayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Boolean getCalculateOutliers() {
    return this.calculateOutliers;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getVentilationIcd10Code() {
    return this.ventilationIcd10Code;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCalculationVersion() {
    return this.calculationVersion;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldLtchBlendPercentage() {
    return this.holdLtchBlendPercentage;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public PaymentType getPaymentType() {
    return this.paymentType;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CbsaWageIndexEntry getRuralWageIndexFloor() {
    return this.ruralWageIndexFloor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CbsaWageIndexEntry getImputedWageIndexFloor() {
    return this.imputedWageIndexFloor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getFyBegin() {
    return this.fyBegin;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getFyEnd() {
    return this.fyEnd;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LtchPaymentData getPaymentData() {
    return this.paymentData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public WageIppsIndexRuralEntry getHoldProvIppsCbsaRural() {
    return this.holdProvIppsCbsaRural;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CbsaWageIndexEntry getHoldProvIppsCBSA() {
    return this.holdProvIppsCBSA;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldCapitalTeachingAdjustmentRatio() {
    return this.holdCapitalTeachingAdjustmentRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldOperatingDshPercent() {
    return this.holdOperatingDshPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldBedSize() {
    return this.holdBedSize;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldOperatingDshAmount() {
    return this.holdOperatingDshAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldIppsWageIndex() {
    return this.holdIppsWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldIppsNationalLaborShare() {
    return this.holdIppsNationalLaborShare;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldStandardAmountOperatingPayment() {
    return this.holdStandardAmountOperatingPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldIppsNationalNonLaborShare() {
    return this.holdIppsNationalNonLaborShare;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldIppsDrgWeight() {
    return this.holdIppsDrgWeight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldCapitalCola() {
    return this.holdCapitalCola;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldCapitalGeographicAreaFactor() {
    return this.holdCapitalGeographicAreaFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldCapitalPayment() {
    return this.holdCapitalPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldCapitalImeTeach() {
    return this.holdCapitalImeTeach;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldCapitalDsh() {
    return this.holdCapitalDsh;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldIppsPayAmount() {
    return this.holdIppsPayAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldIppsDrgALengthOfStay() {
    return this.holdIppsDrgALengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldIppsArithALengthOfStay() {
    return this.holdIppsArithALengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldLengthOfStay() {
    return this.holdLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldIppsPerDiem() {
    return this.holdIppsPerDiem;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldShortStayOutlierThreshold() {
    return this.holdShortStayOutlierThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldLtchBlendAmount() {
    return this.holdLtchBlendAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldShortStayPayAmount() {
    return this.holdShortStayPayAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldIppsBlendPercentage() {
    return this.holdIppsBlendPercentage;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldIppsBlendAmount() {
    return this.holdIppsBlendAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldShortStayBlendedPayment() {
    return this.holdShortStayBlendedPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldOutlierThresholdStandard() {
    return this.holdOutlierThresholdStandard;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldOutlierPayAmountStandard() {
    return this.holdOutlierPayAmountStandard;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldOutlierPayAmountSiteNeutral() {
    return this.holdOutlierPayAmountSiteNeutral;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldOutlierIppsComparable() {
    return this.holdOutlierIppsComparable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldSnCostComparison() {
    return this.holdSnCostComparison;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldSnIppsComparison() {
    return this.holdSnIppsComparison;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldBlendStandard() {
    return this.holdBlendStandard;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldBlendSiteNeutral() {
    return this.holdBlendSiteNeutral;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHoldShortStayBlendIndicator() {
    return this.holdShortStayBlendIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHoldShortStayCostIndicator() {
    return this.holdShortStayCostIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHoldShortStayPerDiemIndicator() {
    return this.holdShortStayPerDiemIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHoldShortStayIppsCompIndicator() {
    return this.holdShortStayIppsCompIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldBlendRtc() {
    return this.holdBlendRtc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldLargeUrbanAddon() {
    return this.holdLargeUrbanAddon;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getHoldRegularDays() {
    return this.holdRegularDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getHoldTotalDays() {
    return this.holdTotalDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getHoldAdmissionDate() {
    return this.holdAdmissionDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getHoldDischargeDate() {
    return this.holdDischargeDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldIPPSLikeAmt() {
    return this.holdIPPSLikeAmt;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldIPPSOutlier() {
    return this.holdIPPSOutlier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getHoldPreDPPPay() {
    return this.holdPreDPPPay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public SecondaryPaymentTypeStandard getSecondaryPaymentTypeStandard() {
    return this.secondaryPaymentTypeStandard;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public SecondaryPaymentTypeSiteNeutral getSecondaryPaymentTypeSiteNeutral() {
    return this.secondaryPaymentTypeSiteNeutral;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReturnCodePart1() {
    return this.returnCodePart1;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getReturnCodePart2() {
    return this.returnCodePart2;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setWageIndexFloor(final WageIppsIndexRuralEntry wageIndexFloor) {
    this.wageIndexFloor = wageIndexFloor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLtchWageIndexTableEntry(final LtchWageIndexTableEntry ltchWageIndexTableEntry) {
    this.ltchWageIndexTableEntry = ltchWageIndexTableEntry;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldLaborPortionRounded(final BigDecimal holdLaborPortionRounded) {
    this.holdLaborPortionRounded = holdLaborPortionRounded;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldNonLaborPortionRounded(final BigDecimal holdNonLaborPortionRounded) {
    this.holdNonLaborPortionRounded = holdNonLaborPortionRounded;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldBudgetNeutralFactor(final BigDecimal holdBudgetNeutralFactor) {
    this.holdBudgetNeutralFactor = holdBudgetNeutralFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldSiteNeutralIppsAdj(final BigDecimal holdSiteNeutralIppsAdj) {
    this.holdSiteNeutralIppsAdj = holdSiteNeutralIppsAdj;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPcPricer(final Boolean pcPricer) {
    this.pcPricer = pcPricer;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setIppsComparablePayment(final Boolean ippsComparablePayment) {
    this.ippsComparablePayment = ippsComparablePayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCalculateOutliers(final Boolean calculateOutliers) {
    this.calculateOutliers = calculateOutliers;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setVentilationIcd10Code(final String ventilationIcd10Code) {
    this.ventilationIcd10Code = ventilationIcd10Code;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCalculationVersion(final String calculationVersion) {
    this.calculationVersion = calculationVersion;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldLtchBlendPercentage(final BigDecimal holdLtchBlendPercentage) {
    this.holdLtchBlendPercentage = holdLtchBlendPercentage;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentType(final PaymentType paymentType) {
    this.paymentType = paymentType;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRuralWageIndexFloor(final CbsaWageIndexEntry ruralWageIndexFloor) {
    this.ruralWageIndexFloor = ruralWageIndexFloor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setImputedWageIndexFloor(final CbsaWageIndexEntry imputedWageIndexFloor) {
    this.imputedWageIndexFloor = imputedWageIndexFloor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFyBegin(final LocalDate fyBegin) {
    this.fyBegin = fyBegin;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFyEnd(final LocalDate fyEnd) {
    this.fyEnd = fyEnd;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPaymentData(final LtchPaymentData paymentData) {
    this.paymentData = paymentData;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldProvIppsCbsaRural(final WageIppsIndexRuralEntry holdProvIppsCbsaRural) {
    this.holdProvIppsCbsaRural = holdProvIppsCbsaRural;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldProvIppsCBSA(final CbsaWageIndexEntry holdProvIppsCBSA) {
    this.holdProvIppsCBSA = holdProvIppsCBSA;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldCapitalTeachingAdjustmentRatio(final BigDecimal holdCapitalTeachingAdjustmentRatio) {
    this.holdCapitalTeachingAdjustmentRatio = holdCapitalTeachingAdjustmentRatio;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldOperatingDshPercent(final BigDecimal holdOperatingDshPercent) {
    this.holdOperatingDshPercent = holdOperatingDshPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldBedSize(final BigDecimal holdBedSize) {
    this.holdBedSize = holdBedSize;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldOperatingDshAmount(final BigDecimal holdOperatingDshAmount) {
    this.holdOperatingDshAmount = holdOperatingDshAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldIppsWageIndex(final BigDecimal holdIppsWageIndex) {
    this.holdIppsWageIndex = holdIppsWageIndex;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldIppsNationalLaborShare(final BigDecimal holdIppsNationalLaborShare) {
    this.holdIppsNationalLaborShare = holdIppsNationalLaborShare;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldStandardAmountOperatingPayment(final BigDecimal holdStandardAmountOperatingPayment) {
    this.holdStandardAmountOperatingPayment = holdStandardAmountOperatingPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldIppsNationalNonLaborShare(final BigDecimal holdIppsNationalNonLaborShare) {
    this.holdIppsNationalNonLaborShare = holdIppsNationalNonLaborShare;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldIppsDrgWeight(final BigDecimal holdIppsDrgWeight) {
    this.holdIppsDrgWeight = holdIppsDrgWeight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldCapitalCola(final BigDecimal holdCapitalCola) {
    this.holdCapitalCola = holdCapitalCola;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldCapitalGeographicAreaFactor(final BigDecimal holdCapitalGeographicAreaFactor) {
    this.holdCapitalGeographicAreaFactor = holdCapitalGeographicAreaFactor;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldCapitalPayment(final BigDecimal holdCapitalPayment) {
    this.holdCapitalPayment = holdCapitalPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldCapitalImeTeach(final BigDecimal holdCapitalImeTeach) {
    this.holdCapitalImeTeach = holdCapitalImeTeach;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldCapitalDsh(final BigDecimal holdCapitalDsh) {
    this.holdCapitalDsh = holdCapitalDsh;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldIppsPayAmount(final BigDecimal holdIppsPayAmount) {
    this.holdIppsPayAmount = holdIppsPayAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldIppsDrgALengthOfStay(final BigDecimal holdIppsDrgALengthOfStay) {
    this.holdIppsDrgALengthOfStay = holdIppsDrgALengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldIppsArithALengthOfStay(final BigDecimal holdIppsArithALengthOfStay) {
    this.holdIppsArithALengthOfStay = holdIppsArithALengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldLengthOfStay(final BigDecimal holdLengthOfStay) {
    this.holdLengthOfStay = holdLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldIppsPerDiem(final BigDecimal holdIppsPerDiem) {
    this.holdIppsPerDiem = holdIppsPerDiem;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldShortStayOutlierThreshold(final BigDecimal holdShortStayOutlierThreshold) {
    this.holdShortStayOutlierThreshold = holdShortStayOutlierThreshold;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldLtchBlendAmount(final BigDecimal holdLtchBlendAmount) {
    this.holdLtchBlendAmount = holdLtchBlendAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldShortStayPayAmount(final BigDecimal holdShortStayPayAmount) {
    this.holdShortStayPayAmount = holdShortStayPayAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldIppsBlendPercentage(final BigDecimal holdIppsBlendPercentage) {
    this.holdIppsBlendPercentage = holdIppsBlendPercentage;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldIppsBlendAmount(final BigDecimal holdIppsBlendAmount) {
    this.holdIppsBlendAmount = holdIppsBlendAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldShortStayBlendedPayment(final BigDecimal holdShortStayBlendedPayment) {
    this.holdShortStayBlendedPayment = holdShortStayBlendedPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldOutlierThresholdStandard(final BigDecimal holdOutlierThresholdStandard) {
    this.holdOutlierThresholdStandard = holdOutlierThresholdStandard;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldOutlierPayAmountStandard(final BigDecimal holdOutlierPayAmountStandard) {
    this.holdOutlierPayAmountStandard = holdOutlierPayAmountStandard;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldOutlierPayAmountSiteNeutral(final BigDecimal holdOutlierPayAmountSiteNeutral) {
    this.holdOutlierPayAmountSiteNeutral = holdOutlierPayAmountSiteNeutral;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldOutlierIppsComparable(final BigDecimal holdOutlierIppsComparable) {
    this.holdOutlierIppsComparable = holdOutlierIppsComparable;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldSnCostComparison(final BigDecimal holdSnCostComparison) {
    this.holdSnCostComparison = holdSnCostComparison;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldSnIppsComparison(final BigDecimal holdSnIppsComparison) {
    this.holdSnIppsComparison = holdSnIppsComparison;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldBlendStandard(final BigDecimal holdBlendStandard) {
    this.holdBlendStandard = holdBlendStandard;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldBlendSiteNeutral(final BigDecimal holdBlendSiteNeutral) {
    this.holdBlendSiteNeutral = holdBlendSiteNeutral;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldShortStayBlendIndicator(final String holdShortStayBlendIndicator) {
    this.holdShortStayBlendIndicator = holdShortStayBlendIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldShortStayCostIndicator(final String holdShortStayCostIndicator) {
    this.holdShortStayCostIndicator = holdShortStayCostIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldShortStayPerDiemIndicator(final String holdShortStayPerDiemIndicator) {
    this.holdShortStayPerDiemIndicator = holdShortStayPerDiemIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldShortStayIppsCompIndicator(final String holdShortStayIppsCompIndicator) {
    this.holdShortStayIppsCompIndicator = holdShortStayIppsCompIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldBlendRtc(final BigDecimal holdBlendRtc) {
    this.holdBlendRtc = holdBlendRtc;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldLargeUrbanAddon(final BigDecimal holdLargeUrbanAddon) {
    this.holdLargeUrbanAddon = holdLargeUrbanAddon;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldRegularDays(final int holdRegularDays) {
    this.holdRegularDays = holdRegularDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldTotalDays(final int holdTotalDays) {
    this.holdTotalDays = holdTotalDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldAdmissionDate(final LocalDate holdAdmissionDate) {
    this.holdAdmissionDate = holdAdmissionDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldDischargeDate(final LocalDate holdDischargeDate) {
    this.holdDischargeDate = holdDischargeDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldIPPSLikeAmt(final BigDecimal holdIPPSLikeAmt) {
    this.holdIPPSLikeAmt = holdIPPSLikeAmt;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldIPPSOutlier(final BigDecimal holdIPPSOutlier) {
    this.holdIPPSOutlier = holdIPPSOutlier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setHoldPreDPPPay(final BigDecimal holdPreDPPPay) {
    this.holdPreDPPPay = holdPreDPPPay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSecondaryPaymentTypeStandard(final SecondaryPaymentTypeStandard secondaryPaymentTypeStandard) {
    this.secondaryPaymentTypeStandard = secondaryPaymentTypeStandard;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSecondaryPaymentTypeSiteNeutral(final SecondaryPaymentTypeSiteNeutral secondaryPaymentTypeSiteNeutral) {
    this.secondaryPaymentTypeSiteNeutral = secondaryPaymentTypeSiteNeutral;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReturnCodePart1(final String returnCodePart1) {
    this.returnCodePart1 = returnCodePart1;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setReturnCodePart2(final String returnCodePart2) {
    this.returnCodePart2 = returnCodePart2;
  }
}
