/*
 * Decompiled with CFR 0.152.
 */
package com.mmm.his.cer.utility.farser.lexer.drg;

import com.mmm.his.cer.utility.farser.lexer.LexerToken;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgFormulaToken;
import java.util.Optional;
import java.util.regex.Pattern;

public class DrgLexerToken
implements LexerToken<DrgFormulaToken> {
    public static final String PREFIX_SEPARATOR_STRING = ":";
    public static final Pattern PREFIX_SEPARATOR_PATTERN = Pattern.compile(":");
    public final DrgFormulaToken type;
    public final String value;
    public final String prefix;

    public DrgLexerToken(DrgFormulaToken type) {
        this.type = type;
        this.value = type.getValue().orElse(null);
        this.prefix = null;
    }

    public DrgLexerToken(DrgFormulaToken type, String value) {
        this.type = type;
        this.value = value;
        this.prefix = null;
    }

    public DrgLexerToken(DrgFormulaToken type, String value, String prefix) {
        this.type = type;
        this.value = value;
        this.prefix = prefix;
    }

    @Override
    public DrgFormulaToken getType() {
        return this.type;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public Optional<String> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    public String toString() {
        if (this.type == DrgFormulaToken.ATOM) {
            String prefixString = "";
            if (this.prefix != null && !this.prefix.equals("")) {
                prefixString = " with prefix " + this.prefix;
            }
            return this.type.name() + "<" + this.value + ">" + prefixString;
        }
        return this.type.toString();
    }
}

