/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.mainframe.utility.v310.util;

import gov.agency.mainframe.utility.v310.util.StringUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;

public class MainframeProperties {
    public static final String PROPERTY_CHARSET = "character.set.to.use";
    public static final String DEFAULT_INPUT_CHARSET_NAME = "ibm1047";
    public static final Charset DEFAULT_INPUT_CHARSET = Charset.forName("ibm1047");
    public static final String DEFAULT_SYSENV_VAR_PROPFILE_LOCATION = "config";
    private Charset inputCharacterSet = DEFAULT_INPUT_CHARSET;
    private String propertyLocation;
    private String propertyLocationSystemEnvVariableName;
    private Properties props;
    private boolean isLoaded = false;

    public MainframeProperties() {
        this(null, DEFAULT_SYSENV_VAR_PROPFILE_LOCATION);
    }

    public MainframeProperties(String propertyPath, String systemEnvVariableName) {
        this.propertyLocation = propertyPath;
        this.propertyLocationSystemEnvVariableName = systemEnvVariableName;
        this.props = new Properties();
        this.isLoaded = false;
    }

    public void setInputCharacterSet(Charset inputCharacterSet) {
        this.inputCharacterSet = inputCharacterSet;
    }

    public Optional<Charset> getInputCharacterSet() {
        return Optional.ofNullable(this.inputCharacterSet);
    }

    public void setPropertyLocation(String propertyLocation) {
        this.propertyLocation = propertyLocation;
        this.isLoaded = false;
    }

    public String getPropertyLocation() {
        return this.propertyLocation;
    }

    public void setPropertyLocationSystemEnvVariableName(String envVariableName) {
        this.propertyLocationSystemEnvVariableName = envVariableName;
        this.isLoaded = false;
    }

    public String getPropertyLocationSystemEnvVariableName() {
        return this.propertyLocationSystemEnvVariableName;
    }

    public void load() throws IOException {
        if (this.isLoaded) {
            return;
        }
        File propFile = null;
        String filePathAndName = null;
        if (this.propertyLocationSystemEnvVariableName != null && !StringUtilities.isNullOrEmpty(this.propertyLocationSystemEnvVariableName)) {
            filePathAndName = System.getenv(this.propertyLocationSystemEnvVariableName);
        }
        if (StringUtilities.isNullOrEmpty(filePathAndName)) {
            if (!StringUtilities.isNullOrEmpty(this.propertyLocation)) {
                filePathAndName = this.propertyLocation;
            } else {
                return;
            }
        }
        propFile = new File(filePathAndName);
        try (InputStream is = null;){
            if (!propFile.exists()) {
                is = this.getClass().getResourceAsStream(filePathAndName);
                if (is == null) {
                    throw new FileNotFoundException(String.format("Unable to load properties file. No file found as resource at '%s' or on file system as '%s'", filePathAndName, propFile.getCanonicalPath()));
                }
            } else {
                is = new FileInputStream(propFile);
            }
            this.props.load(is);
        }
        MainframeProperties.getProperty(this.props, PROPERTY_CHARSET, DEFAULT_INPUT_CHARSET, Charset::forName).ifPresent(value -> {
            this.inputCharacterSet = value;
        });
        this.isLoaded = true;
    }

    public void setProperty(String key, String property) {
        this.props.setProperty(key, key);
    }

    public <P> Optional<P> getProperty(String key, P defaultValue, Function<String, P> valueConverter) {
        return MainframeProperties.getProperty(this.props, key, defaultValue, valueConverter);
    }

    public Optional<String> getProperty(String key, String defaultValue) {
        return MainframeProperties.getProperty(this.props, key, defaultValue, val -> val);
    }

    public Optional<String> getProperty(String key) {
        return MainframeProperties.getProperty(this.props, key, null, val -> val);
    }

    public <P> Optional<P> getProperty(String key, Function<String, P> valueConverter) {
        return MainframeProperties.getProperty(this.props, key, null, valueConverter);
    }

    private static <P> Optional<P> getProperty(Properties props, String key, P defaultValue, Function<String, P> valueConverter) {
        String value = props.getProperty(key);
        if (StringUtilities.isNullOrEmpty(value)) {
            if (defaultValue != null) {
                return Optional.of(defaultValue);
            }
            return Optional.empty();
        }
        return Optional.ofNullable(valueConverter.apply(value));
    }
}

