/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.model;

import gov.agency.msdrg.model.MsdrgHac;
import gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag;
import gov.agency.msdrg.model.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.enumeration.MsdrgPoaErrorCode;
import java.util.Collections;
import java.util.List;

public class MsdrgDiagnosisFlag {
    private final boolean diagnosisRecognizedByGrouper;
    private final MsdrgGroupingImpact diagnosisAffectsDrg;
    private final MsdrgCodeSeverityFlag finalSeverityUsage;
    private final MsdrgCodeSeverityFlag initialSeverityUsage;
    private final MsdrgPoaErrorCode poaErrorCode;
    private final List<MsdrgHac> hacs;

    public MsdrgDiagnosisFlag() {
        this.diagnosisRecognizedByGrouper = false;
        this.diagnosisAffectsDrg = MsdrgGroupingImpact.NONE;
        this.finalSeverityUsage = MsdrgCodeSeverityFlag.NEITHER;
        this.initialSeverityUsage = MsdrgCodeSeverityFlag.NEITHER;
        this.poaErrorCode = MsdrgPoaErrorCode.POA_NOT_CHECKED;
        this.hacs = Collections.emptyList();
    }

    public MsdrgDiagnosisFlag(boolean diagnosisRecognizedByGrouper, MsdrgGroupingImpact diagnosisAffectsDrg, MsdrgCodeSeverityFlag finalSeverityUsage, MsdrgCodeSeverityFlag initialSeverityUsage, MsdrgPoaErrorCode poaErrorCode, List<MsdrgHac> hacs) {
        this.diagnosisRecognizedByGrouper = diagnosisRecognizedByGrouper;
        this.diagnosisAffectsDrg = diagnosisAffectsDrg;
        this.finalSeverityUsage = finalSeverityUsage;
        this.initialSeverityUsage = initialSeverityUsage;
        this.poaErrorCode = poaErrorCode;
        this.hacs = hacs;
    }

    public boolean isDiagnosisRecognizedByGrouper() {
        return this.diagnosisRecognizedByGrouper;
    }

    public MsdrgGroupingImpact getDiagnosisAffectsDrg() {
        return this.diagnosisAffectsDrg;
    }

    public MsdrgCodeSeverityFlag getFinalSeverityUsage() {
        return this.finalSeverityUsage;
    }

    public MsdrgCodeSeverityFlag getInitialSeverityUsage() {
        return this.initialSeverityUsage;
    }

    public MsdrgPoaErrorCode getPoaErrorCode() {
        return this.poaErrorCode;
    }

    public List<MsdrgHac> getHacs() {
        return this.hacs;
    }

    public String toString() {
        int[] dxFlags = new int[25];
        if (!this.isDiagnosisRecognizedByGrouper()) {
            return "0                        ";
        }
        dxFlags[0] = 1;
        dxFlags[1] = this.diagnosisAffectsDrg.intValue();
        dxFlags[2] = this.finalSeverityUsage.intValue();
        dxFlags[3] = this.initialSeverityUsage.intValue();
        dxFlags[4] = this.poaErrorCode.intValue();
        int index = 5;
        for (MsdrgHac hac : this.hacs) {
            dxFlags[index] = hac.getHacStatus().getIntValue();
            if (hac.getHacNumber() < 10) {
                dxFlags[index + 1] = 0;
                dxFlags[index + 2] = hac.getHacNumber();
                index += 3;
                continue;
            }
            dxFlags[index + 1] = Integer.parseInt(Integer.toString(hac.getHacNumber()).substring(0, 1));
            dxFlags[index + 2] = Integer.parseInt(Integer.toString(hac.getHacNumber()).substring(1, 2));
            index += 3;
        }
        if (index != 15) {
            for (int k = index; k < 15; ++k) {
                dxFlags[k] = 0;
            }
        }
        dxFlags[15] = 0;
        dxFlags[16] = 0;
        dxFlags[17] = 0;
        dxFlags[18] = 0;
        dxFlags[19] = 0;
        dxFlags[20] = 0;
        dxFlags[21] = 0;
        dxFlags[22] = 0;
        dxFlags[23] = 0;
        dxFlags[24] = 0;
        StringBuilder str = new StringBuilder();
        for (int l = 0; l <= 24; ++l) {
            str.append(dxFlags[l]);
        }
        return str.toString();
    }
}

