/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.model;

import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgCode;
import gov.agency.msdrg.model.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.enumeration.MsdrgProcedureHacUsage;
import gov.agency.msdrg.model.enumeration.MsdrgSourceLogicLists;
import gov.agency.msdrg.model.transfer.MsdrgInputPrCode;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class MsdrgProcedureCode
implements MsdrgCode {
    private final MsdrgInputPrCode inputPrCode;
    private Set<Attribute> attributes;
    private BitSet mdcSuppression;
    private Set<String> clusterIds;
    private boolean isValidCode;
    private MsdrgGroupingImpact drgImpact = MsdrgGroupingImpact.NONE;
    private boolean isOperatingRoomProcedure = true;
    private Set<MsdrgProcedureHacUsage> hacUsageFlag = new HashSet<MsdrgProcedureHacUsage>();
    private boolean isInitialMarked = false;
    private boolean isFinalMarked = false;
    private boolean isCluster = false;
    private boolean bilateral = false;
    private boolean vessels4 = false;
    private boolean stents4 = false;
    private boolean isFirstPosition = false;

    public MsdrgProcedureCode(MsdrgInputPrCode inputPrCode) {
        this.inputPrCode = inputPrCode;
        this.mdcSuppression = new BitSet(32);
        this.clusterIds = new HashSet<String>();
    }

    @Override
    public Set<Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Set<Attribute> attributes) {
        this.attributes = attributes;
        this.applyOperatingRoom();
    }

    public MsdrgInputPrCode getInputPrCode() {
        return this.inputPrCode;
    }

    @Override
    public String getValue() {
        return this.inputPrCode.getValue();
    }

    public boolean isFirstPosition() {
        return this.isFirstPosition;
    }

    public void setFirstPosition(boolean firstPosition) {
        this.isFirstPosition = firstPosition;
    }

    private void applyOperatingRoom() {
        this.attributes.stream().filter(item -> item.getListName().equalsIgnoreCase(MsdrgSourceLogicLists.NONOR.getValue())).findAny().ifPresent(attribute -> this.setOperatingRoomProcedure(false));
    }

    public Set<String> getClusterIds() {
        return this.clusterIds;
    }

    public void setClusterIds(Set<String> clusterIds) {
        this.clusterIds = clusterIds;
    }

    public BitSet getMdcSuppression() {
        return this.mdcSuppression;
    }

    public void setMdcSuppression(Set<Integer> mdcSupression) {
        for (Integer integer : mdcSupression) {
            this.mdcSuppression.set(integer);
        }
    }

    public boolean isValidCode() {
        return this.isValidCode;
    }

    public void setValidCode(boolean validCode) {
        this.isValidCode = validCode;
    }

    @Override
    public MsdrgGroupingImpact getDrgImpact() {
        return this.drgImpact;
    }

    @Override
    public void setDrgImpact(MsdrgGroupingImpact drgImpact) {
        this.drgImpact = drgImpact;
    }

    public boolean isOperatingRoomProcedure() {
        return this.isOperatingRoomProcedure;
    }

    public void setOperatingRoomProcedure(boolean operatingRoomProcedure) {
        this.isOperatingRoomProcedure = operatingRoomProcedure;
    }

    public Set<MsdrgProcedureHacUsage> getHacUsageFlag() {
        return this.hacUsageFlag;
    }

    public void setHacUsageFlag(Set<MsdrgProcedureHacUsage> hacUsageFlag) {
        this.hacUsageFlag = hacUsageFlag;
    }

    public boolean isCluster() {
        return this.isCluster;
    }

    public void setCluster(boolean cluster) {
        this.isCluster = cluster;
    }

    public boolean hasAttribute(Attribute attribute) {
        return this.attributes.contains(attribute);
    }

    public boolean isInitialMarked() {
        return this.isInitialMarked;
    }

    @Override
    public void setInitialMarked(boolean initialMarked) {
        this.isInitialMarked = initialMarked;
    }

    public boolean isFinalMarked() {
        return this.isFinalMarked;
    }

    @Override
    public void setFinalMarked(boolean finalMarked) {
        this.isFinalMarked = finalMarked;
    }

    public boolean isBilateral() {
        return this.bilateral;
    }

    public void setBilateral(boolean bilateral) {
        this.bilateral = bilateral;
    }

    public boolean isVessels4() {
        return this.vessels4;
    }

    public void setVessels4(boolean vessels4) {
        this.vessels4 = vessels4;
    }

    public boolean isStents4() {
        return this.stents4;
    }

    public void setStents4(boolean stents4) {
        this.stents4 = stents4;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MsdrgProcedureCode)) {
            return false;
        }
        MsdrgProcedureCode that = (MsdrgProcedureCode)o;
        return this.isValidCode == that.isValidCode && this.isOperatingRoomProcedure == that.isOperatingRoomProcedure && this.isInitialMarked == that.isInitialMarked && this.isFinalMarked == that.isFinalMarked && this.isCluster == that.isCluster && this.bilateral == that.bilateral && this.vessels4 == that.vessels4 && this.stents4 == that.stents4 && this.isFirstPosition == that.isFirstPosition && Objects.equals(this.inputPrCode, that.inputPrCode) && Objects.equals(this.attributes, that.attributes) && Objects.equals(this.mdcSuppression, that.mdcSuppression) && Objects.equals(this.clusterIds, that.clusterIds) && this.drgImpact == that.drgImpact && Objects.equals(this.hacUsageFlag, that.hacUsageFlag);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.inputPrCode, this.attributes, this.mdcSuppression, this.clusterIds, this.isValidCode, this.drgImpact, this.isOperatingRoomProcedure, this.hacUsageFlag, this.isInitialMarked, this.isFinalMarked, this.isCluster, this.bilateral, this.vessels4, this.stents4, this.isFirstPosition});
    }
}

