/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390;

import com.mmm.his.cer.foundation.Processable;
import com.mmm.his.cer.foundation.exception.FoundationException;
import com.mmm.his.cer.foundation.model.GfcPoa;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgCode;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgGrouperFlags;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.MsdrgOption;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import gov.agency.msdrg.model.MsdrgRuntimeOption;
import gov.agency.msdrg.model.RuntimeOptions;
import gov.agency.msdrg.model.enumeration.MarkingLogicTieBreaker;
import gov.agency.msdrg.model.enumeration.MsdrgChainContext;
import gov.agency.msdrg.model.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.enumeration.MsdrgSex;
import gov.agency.msdrg.model.enumeration.MsdrgSourceLogicLists;
import gov.agency.msdrg.model.transfer.MsdrgClaim;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.model.transfer.MsdrgInputData;
import gov.agency.msdrg.model.transfer.MsdrgInputDxCode;
import gov.agency.msdrg.model.transfer.MsdrgInputPrCode;
import gov.agency.msdrg.model.transfer.MsdrgOutput;
import gov.agency.msdrg.v390.ProcessingData;
import gov.agency.msdrg.v390.access.MsdrgInteractionBlobDao;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import gov.agency.msdrg.v390.access.blob.DataBlob;
import gov.agency.msdrg.v390.access.pojo.MsdrgDrgFormulas;
import gov.agency.msdrg.v390.chain.GrouperChain;
import gov.agency.msdrg.v390.chain.ProcessingContext;
import gov.agency.msdrg.v390.logic.FormulaEvaluator;
import gov.agency.msdrg.v390.logic.MsdrgCodeFlagsProcessor;
import gov.agency.msdrg.v390.logic.MsdrgGrouperFlagsResult;
import gov.agency.msdrg.v390.logic.RuntimeDataValidation;
import gov.agency.msdrg.v390.logic.ast.BilateralAstNode;
import gov.agency.msdrg.v390.logic.ast.DrugEludingStentAstNode;
import gov.agency.msdrg.v390.logic.ast.NonDrugEludingStentAstNode;
import gov.agency.msdrg.v390.logic.ast.SigTraumaAstNode;
import gov.agency.msdrg.v390.logic.ast.VesselAstNode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgComponent
implements Processable<MsdrgClaim, MsdrgOption, MsdrgRuntimeOption> {
    public static final String NULL_CODE_VALUE = String.valueOf(null);
    public static final GfcPoa NULL_POA = GfcPoa.BLANK;
    private static final Logger logger = LoggerFactory.getLogger(MsdrgComponent.class);
    private final Map<String, NodeSupplier<DrgLexerToken, Attribute>> supplierMap = new HashMap<String, NodeSupplier<DrgLexerToken, Attribute>>();
    private MsdrgInteractionDao dbInteraction;
    private RuntimeOptions options;

    public MsdrgComponent(MsdrgRuntimeOption options) {
        logger.debug("Initializing component constructor");
        this.options = (RuntimeOptions)options.get((Object)MsdrgOption.RUNTIME_OPTION_FLAGS);
        this.initialize();
    }

    protected void initialize() {
        this.dbInteraction = new MsdrgInteractionBlobDao(DataBlob.getInstance());
        this.supplierMap.put(MsdrgSourceLogicLists.BILATERAL.getValue(), new BilateralAstNode.BilateralNodeSupplier());
        this.supplierMap.put(MsdrgSourceLogicLists.FOUR_VESSELS.getValue(), new VesselAstNode.VesselNodeSupplier());
        this.supplierMap.put(MsdrgSourceLogicLists.MULTST.getValue(), new SigTraumaAstNode.SigTraumaNodeSupplier());
        this.supplierMap.put(MsdrgSourceLogicLists.FOUR_DRUG_ELUTING_STENTS.getValue(), new DrugEludingStentAstNode.DrugEludingNodeSupplier());
        this.supplierMap.put(MsdrgSourceLogicLists.FOUR_NON_DRUG_ELUTING_STENTS.getValue(), new NonDrugEludingStentAstNode.NonDrugEludingNodeSupplier());
        for (int i = 0; i < 30; ++i) {
            List<MsdrgDrgFormulas> allFormulaRowsByMdc = this.dbInteraction.getAllFormulaRowsByMdc(i);
            if (allFormulaRowsByMdc == null) continue;
            for (MsdrgDrgFormulas msdrgDrgFormulas : allFormulaRowsByMdc) {
                FormulaEvaluator.lexFormula(msdrgDrgFormulas.getFormula());
            }
        }
    }

    @Override
    public void process(MsdrgClaim claim) throws FoundationException {
        logger.debug("Begin processing claim");
        RuntimeOptions runtime = RuntimeDataValidation.execute(this.options);
        ProcessingData processingData = this.createProcessingData(claim);
        ArrayList<MsdrgProcedureCode> originalProcedureOrder = new ArrayList<MsdrgProcedureCode>(processingData.getProcedureCodes());
        ArrayList<MsdrgDiagnosisCode> originalDiagnosisOrder = new ArrayList<MsdrgDiagnosisCode>(processingData.getSdxCodes());
        if (runtime.getMarkingLogicTieBreaker() == MarkingLogicTieBreaker.CLINICAL_SIGNIFICANCE) {
            ArrayList<MsdrgProcedureCode> procCodes = new ArrayList<MsdrgProcedureCode>(processingData.getProcedureCodes());
            procCodes.sort(Comparator.comparing(MsdrgCode::getValue));
            processingData = processingData.toBuilder().withProcedures(procCodes).build();
        }
        ProcessingContext context = new ProcessingContext();
        context.put(MsdrgChainContext.ACCESS, this.dbInteraction);
        context.put(MsdrgChainContext.RUNTIME_OPTIONS, runtime);
        context.put(MsdrgChainContext.AST_SUPPLIER_MAP, this.supplierMap);
        context.put(MsdrgChainContext.PROCESSING_DATA, processingData);
        GrouperChain.LOGIC.execute(context);
        ProcessingData processedData = (ProcessingData)context.get(MsdrgChainContext.PROCESSING_DATA);
        if (processedData.getSdxCodes() != null) {
            processedData = processedData.toBuilder().withSdxCodes(originalDiagnosisOrder).build();
        }
        if (processedData.getProcedureCodes() != null) {
            processedData = processedData.toBuilder().withProcedures(originalProcedureOrder).build();
        }
        MsdrgOutput output = this.createOutput(processedData, runtime, (MsdrgMatchedDrgFormula)context.get(MsdrgChainContext.INITIAL_MATCHED_FORMULA), (MsdrgMatchedDrgFormula)context.get(MsdrgChainContext.FINAL_MATCHED_FORMULA), !context.containsKey((Object)MsdrgChainContext.FINAL_MATCHED_FORMULA), processedData.getDischargeStatus());
        claim.setOutput(output);
    }

    private MsdrgOutput createOutput(ProcessingData processedData, RuntimeOptions runtimeOptions, MsdrgMatchedDrgFormula initialMatchedFormula, MsdrgMatchedDrgFormula finalMatchedFormula, boolean didNotReachFinal, MsdrgDischargeStatus dischargeStatus) {
        MsdrgGrouperFlags grouperFlags = MsdrgGrouperFlagsResult.createGrouperFlags(processedData, runtimeOptions.getPoaReportingExempt(), runtimeOptions.getComputeAffectDrg(), initialMatchedFormula, finalMatchedFormula);
        MsdrgGrouperResult initialResult = processedData.getInitialResult();
        MsdrgCodeFlagsProcessor.TempFlagsContainer tempFlagsContainer = MsdrgCodeFlagsProcessor.processCodeFlags(processedData, dischargeStatus, didNotReachFinal, initialResult.getDrg(), initialResult.getReturnCode());
        return MsdrgOutput.builder().withProcOutput(tempFlagsContainer.getProcFlagMap()).withSdxOutput(tempFlagsContainer.getDxFlagMap()).withFinalGrouperResult(processedData.getFinalResult()).withInitialGrouperResult(processedData.getInitialResult()).withPdxOutput(tempFlagsContainer.getPdxFlagMap()).withGrouperFlags(grouperFlags).build();
    }

    private ProcessingData createProcessingData(MsdrgClaim claim) {
        MsdrgInputData input = claim.getInput();
        MsdrgInputDxCode pdx = input.getPrincipalDiagnosisCode().orElse(new MsdrgInputDxCode(NULL_CODE_VALUE, NULL_POA));
        MsdrgInputDxCode admit = input.getAdmissionDiagnosisCode().orElse(new MsdrgInputDxCode(NULL_CODE_VALUE, NULL_POA));
        ArrayList<MsdrgDiagnosisCode> sdxCodes = new ArrayList<MsdrgDiagnosisCode>();
        for (MsdrgInputDxCode secondaryDiagnosisCode : input.getSecondaryDiagnosisCodes()) {
            if (secondaryDiagnosisCode == null) {
                sdxCodes.add(new MsdrgDiagnosisCode(new MsdrgInputDxCode(NULL_CODE_VALUE, NULL_POA)));
                continue;
            }
            sdxCodes.add(new MsdrgDiagnosisCode(secondaryDiagnosisCode));
        }
        ProcessingData.ProcessingDataBuilder processingDataBuilder = ProcessingData.builder().withAdmitDx(new MsdrgDiagnosisCode(admit)).withPdx(new MsdrgDiagnosisCode(pdx)).withSdxCodes(sdxCodes).withDischargeStatus(input.getDischargeStatus().orElse(MsdrgDischargeStatus.NONE)).withSex(input.getSex().orElse(MsdrgSex.UNKNOWN));
        if (!input.getProcedureCodes().isEmpty()) {
            ArrayList<MsdrgProcedureCode> procedureCodes = new ArrayList<MsdrgProcedureCode>();
            for (MsdrgInputPrCode procedureCode : input.getProcedureCodes()) {
                if (procedureCode == null) {
                    procedureCodes.add(new MsdrgProcedureCode(new MsdrgInputPrCode(NULL_CODE_VALUE)));
                    continue;
                }
                procedureCodes.add(new MsdrgProcedureCode(procedureCode));
            }
            MsdrgProcedureCode code = (MsdrgProcedureCode)procedureCodes.get(0);
            if (code != null) {
                code.setFirstPosition(true);
            }
            processingDataBuilder.withPrincipalProcedure(code).withProcedures(procedureCodes);
        }
        return processingDataBuilder.build();
    }

    @Override
    public void reconfigure(MsdrgRuntimeOption option) {
        this.options = (RuntimeOptions)option.get((Object)MsdrgOption.RUNTIME_OPTION_FLAGS);
    }

    public RuntimeOptions getOptions() {
        return this.options;
    }

    @Override
    public void close() {
    }
}

