/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.access;

import com.mmm.his.cer.foundation.exception.FoundationRuntimeException;
import gov.agency.msdrg.Data;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.ClusterChoices;
import gov.agency.msdrg.model.MsdrgHac;
import gov.agency.msdrg.model.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import gov.agency.msdrg.v390.access.blob.MapAccess;
import gov.agency.msdrg.v390.access.blob.dto.ClusterParts;
import gov.agency.msdrg.v390.access.blob.dto.HacFormula;
import gov.agency.msdrg.v390.access.pojo.MsdrgClusterDefinition;
import gov.agency.msdrg.v390.access.pojo.MsdrgDrgFormulas;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class MsdrgInteractionBlobDao
implements MsdrgInteractionDao {
    private final MapAccess access;

    public MsdrgInteractionBlobDao(MapAccess dataBlob) {
        this.access = dataBlob;
    }

    @Override
    public boolean isCodeValid(String code) {
        return this.access.isCodeValid(code);
    }

    @Override
    public List<String> getExclusions(String pdxCode) {
        return this.access.getExclusionsForCode(pdxCode);
    }

    @Override
    public Set<MsdrgClusterDefinition> getClusters(List<String> procCodes) {
        HashSet<MsdrgClusterDefinition> clusters = new HashSet<MsdrgClusterDefinition>();
        for (String procCode : procCodes) {
            List<String> clusterIds = this.access.getClusterId(procCode);
            if (clusterIds == null) continue;
            for (String clusterId : clusterIds) {
                ClusterParts parts = new ClusterParts();
                Optional<Data.ClusterData> maybeClusterData = this.access.getClusterParts(clusterId);
                if (!maybeClusterData.isPresent()) continue;
                Data.ClusterData clusterData = maybeClusterData.get();
                ClusterChoices.ClusterChoicesBuilder choicesBuilder = ClusterChoices.builder();
                for (Data.ClusterChoice clusterChoice : clusterData.getChoicesList()) {
                    choicesBuilder.withChoice(clusterChoice.getChoice(), new HashSet<String>(clusterChoice.getCodesList()));
                }
                parts.setChoices(choicesBuilder.build());
                parts.setCodes(new HashSet<String>(clusterData.getCodesList()));
                parts.setSuppressionMdcs(new HashSet<Integer>(clusterData.getSupressionMdcsList()));
                clusters.add(new MsdrgClusterDefinition(clusterId, parts));
            }
        }
        return clusters;
    }

    @Override
    public Optional<Integer> getMdcOfCode(String code) {
        return this.access.getCodeMdc(code);
    }

    @Override
    public Integer getMdcOfGenderCode(String code, int gender) {
        return this.access.getCodeGenderMdcs(code).get(gender);
    }

    @Override
    public Optional<String> getSeverityOfCode(String code) {
        return this.access.getCodeSeverity(code);
    }

    @Override
    public List<MsdrgDrgFormulas> getAllFormulaRowsByMdc(int mdc) {
        return this.access.getDrgFormulasForMdc(mdc);
    }

    @Override
    public Optional<Integer> getClinicalSignificanceOfCode(String code) {
        return this.access.getClinicalSignificance(code);
    }

    @Override
    public boolean isCodeOnGenderList(String code) {
        Map<Integer, Integer> genderMdcs = this.access.getCodeGenderMdcs(code);
        return !genderMdcs.isEmpty();
    }

    @Override
    public List<HacFormula> getFormulasForHacList(int hacNumber) {
        return this.access.getHacFormulas(hacNumber);
    }

    @Override
    public List<MsdrgHac> getHacsForCode(String code) {
        List<String> hacOperands = this.access.getHacOperands(code);
        List<Integer> hacNumbers = this.access.getHacNumbers(code);
        HashSet<Integer> distinctHacNumbers = new HashSet<Integer>(hacNumbers);
        ArrayList<MsdrgHac> returnList = new ArrayList<MsdrgHac>();
        for (int i = 0; i < distinctHacNumbers.size(); ++i) {
            Integer hacNumber = hacNumbers.get(i);
            MsdrgHac hac = new MsdrgHac();
            hac.setHacList(hacOperands.get(i));
            hac.setHacNumber(hacNumber);
            hac.setDescription(this.getHacDescription(hacNumber));
            returnList.add(hac);
        }
        return returnList;
    }

    @Override
    public Set<Attribute> getAttributesForCode(String code, List<Integer> operandType, String type) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        List<String> attrStrings = type.equalsIgnoreCase("none") ? this.access.getPrAttributes(code) : this.access.getDxAttributes(code);
        for (String attrString : attrStrings) {
            Attribute attribute;
            if (attrString.equals("")) continue;
            if (type.equalsIgnoreCase("pdx")) {
                attribute = new Attribute(MsdrgAttributePrefix.PDX, false, attrString);
                attributes.add(attribute);
                continue;
            }
            if (type.equalsIgnoreCase("sdx")) {
                attribute = new Attribute(MsdrgAttributePrefix.SDX, false, attrString);
                attributes.add(attribute);
                continue;
            }
            attribute = new Attribute(MsdrgAttributePrefix.NONE, false, attrString);
            attributes.add(attribute);
        }
        return attributes;
    }

    @Override
    public Set<Attribute> getDxCatListForCode(String code, List<Integer> operandType, String type) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        List<String> attrStrings = this.access.getDxCatAttributes(code);
        for (String attrString : attrStrings) {
            Attribute attribute;
            if (attrString.equals("")) continue;
            if (type.equalsIgnoreCase("pdx")) {
                attribute = new Attribute(MsdrgAttributePrefix.PDX, false, attrString);
                attributes.add(attribute);
                continue;
            }
            if (!type.equalsIgnoreCase("sdx")) continue;
            attribute = new Attribute(MsdrgAttributePrefix.SDX, false, attrString);
            attributes.add(attribute);
        }
        return attributes;
    }

    @Override
    public Set<Attribute> getDxHacAttributesForCode(String code, List<Integer> operandType, String type) {
        HashSet<Attribute> attributes = new HashSet<Attribute>();
        List<String> attrStrings = this.access.getDxHacAttributes(code);
        for (String attrString : attrStrings) {
            Attribute attribute;
            if (attrString.equals("")) continue;
            if (type.equalsIgnoreCase("pdx")) {
                attribute = new Attribute(MsdrgAttributePrefix.PDX, false, attrString);
                attributes.add(attribute);
                continue;
            }
            if (!type.equalsIgnoreCase("sdx")) continue;
            attribute = new Attribute(MsdrgAttributePrefix.SDX, false, attrString);
            attributes.add(attribute);
        }
        return attributes;
    }

    @Override
    public String getBaseDrgDescription(int drg) {
        return this.access.getBaseDrgDescription(drg).orElseThrow(() -> new FoundationRuntimeException("Unable to get Base DRG description for value: " + drg));
    }

    @Override
    public String getDrgDescription(int drg) {
        return this.access.getDrgDescription(drg).orElseThrow(() -> new FoundationRuntimeException("Unable to get DRG description for value: " + drg));
    }

    @Override
    public String getMdcDescription(int mdc) {
        return this.access.getMdcDescription(mdc).orElseThrow(() -> new FoundationRuntimeException("Unable to get MDC description for value: " + mdc));
    }

    @Override
    public String getHacDescription(int hac) {
        return this.access.getHacDescription(hac).orElseThrow(() -> new FoundationRuntimeException("Unable to get HAC description for value: " + hac));
    }
}

