/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic;

import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgHac;
import gov.agency.msdrg.model.enumeration.MsdrgCodeType;
import gov.agency.msdrg.model.enumeration.MsdrgOperandType;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class DiagnosisAttributeProcessor {
    protected MsdrgInteractionDao dataAccess;

    protected Set<Attribute> getDiagnosisAttributes(MsdrgDiagnosisCode code, MsdrgCodeType type) {
        return this.dataAccess.getAttributesForCode(code.getValue(), Collections.singletonList(MsdrgOperandType.DX_LIST.getOperandTypeInt()), type.toString());
    }

    protected Set<Attribute> getDiagnosisHacAttributes(MsdrgDiagnosisCode code, MsdrgCodeType type) {
        return this.dataAccess.getDxHacAttributesForCode(code.getValue(), Collections.singletonList(MsdrgOperandType.DX_HAC.getOperandTypeInt()), type.toString());
    }

    protected Set<Attribute> getDiagnosisDxCatAttributes(MsdrgDiagnosisCode code, MsdrgCodeType type) {
        return this.dataAccess.getDxCatListForCode(code.getValue(), Collections.singletonList(MsdrgOperandType.DX_CATEGORY.getOperandTypeInt()), type.toString());
    }

    protected List<MsdrgHac> getDiagnosisHac(MsdrgDiagnosisCode code) {
        return this.dataAccess.getHacsForCode(code.getValue());
    }

    protected MsdrgSeverity getDiagnosisSeverity(MsdrgDiagnosisCode code) throws IOException, SQLException {
        return MsdrgSeverity.fromString(this.dataAccess.getSeverityOfCode(code.getValue()).orElse("NCC"));
    }

    protected int getDiagnosisMdc(MsdrgDiagnosisCode code) throws IOException, SQLException {
        return this.dataAccess.getMdcOfCode(code.getValue()).orElse(-1);
    }
}

