/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic;

import com.mmm.his.cer.utility.farser.ast.DrgSyntaxTree;
import com.mmm.his.cer.utility.farser.ast.node.terminal.ContainsNode;
import com.mmm.his.cer.utility.farser.ast.node.type.BooleanExpression;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.ast.parser.DescentParser;
import com.mmm.his.cer.utility.farser.ast.parser.ExpressionResult;
import com.mmm.his.cer.utility.farser.lexer.DrgFormulaLexer;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgMaskAttributes;
import gov.agency.msdrg.model.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.v390.logic.ast.SuppressionContainsNode;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class FormulaEvaluator {
    protected Map<String, NodeSupplier<DrgLexerToken, Attribute>> suppliers;
    protected AttributeOperandSupplier defaultSupplier = new AttributeOperandSupplier();
    protected SuppressionContainsNode.SuppressionNodeSupplier defaultSuppressionSupplier = new SuppressionContainsNode.SuppressionNodeSupplier();
    protected static Map<String, List<DrgLexerToken>> lexedFormulas = new ConcurrentHashMap<String, List<DrgLexerToken>>();

    protected ExpressionResult<Attribute> evaluateFormula(MsdrgMaskAttributes mask, String formula, Integer mdc) {
        List lexerTokens = lexedFormulas.computeIfAbsent(formula, key -> DrgFormulaLexer.lex(formula));
        this.defaultSuppressionSupplier.setRestrictions(mdc);
        DescentParser<Attribute> parser = new DescentParser<Attribute>(lexerTokens.listIterator(), this.defaultSuppressionSupplier, this.suppliers);
        DrgSyntaxTree<Attribute> syntaxTree = parser.buildExpressionTree();
        return syntaxTree.evaluateExpression(mask.getMask());
    }

    protected ExpressionResult<Attribute> evaluateFormulaWithoutSuppression(MsdrgMaskAttributes mask, String formula) {
        List lexerTokens = lexedFormulas.computeIfAbsent(formula, key -> DrgFormulaLexer.lex(formula));
        DescentParser<Attribute> parser = new DescentParser<Attribute>(lexerTokens.listIterator(), this.defaultSupplier, this.suppliers);
        DrgSyntaxTree<Attribute> syntaxTree = parser.buildExpressionTree();
        return syntaxTree.evaluateExpression(mask.getMask());
    }

    public static void lexFormula(String formula) {
        lexedFormulas.computeIfAbsent(formula, key -> DrgFormulaLexer.lex(formula));
    }

    public void setSuppliers(Map<String, NodeSupplier<DrgLexerToken, Attribute>> suppliers) {
        this.suppliers = suppliers;
    }

    private static class AttributeOperandSupplier
    implements NodeSupplier<DrgLexerToken, Attribute> {
        private AttributeOperandSupplier() {
        }

        @Override
        public BooleanExpression<Attribute> createNode(DrgLexerToken token) {
            String prefix = token.getPrefix().orElse("NONE");
            Attribute operand = new Attribute(MsdrgAttributePrefix.getPrefixFromString(prefix), token.getValue());
            return new ContainsNode<Attribute>(operand);
        }
    }
}

