/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic;

import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.enumeration.MsdrgMedSurgType;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;

public class MsdrgGrouperResultReport {
    public MsdrgGrouperResult createGrouperResult(int mdc, MsdrgMatchedDrgFormula matchedDrg, MsdrgSeverity severity, MsdrgInteractionDao dataAccess) {
        MsdrgGrouperResult.MsdrgGrouperResultBuilder resultBuilder = MsdrgGrouperResult.builder();
        int baseDrg = matchedDrg.getBaseDrg();
        int drg = matchedDrg.getDrg();
        String mdcDesc = dataAccess.getMdcDescription(mdc);
        String drgDesc = dataAccess.getDrgDescription(drg);
        String baseDrgDesc = dataAccess.getBaseDrgDescription(baseDrg);
        resultBuilder.withMdc(mdc);
        resultBuilder.withMdcDescription(mdcDesc);
        resultBuilder.withBaseDrg(baseDrg);
        resultBuilder.withBaseDrgDescription(baseDrgDesc);
        resultBuilder.withDrg(drg);
        resultBuilder.withDrgDescription(drgDesc);
        resultBuilder.withSeverity(severity);
        if (matchedDrg.getSurgical() != null) {
            if (matchedDrg.getSurgical().equalsIgnoreCase("SURGICAL")) {
                resultBuilder.withMedicalOrSurgical(MsdrgMedSurgType.SURGICAL);
            } else if (matchedDrg.getSurgical().equalsIgnoreCase("MEDICAL")) {
                resultBuilder.withMedicalOrSurgical(MsdrgMedSurgType.MEDICAL);
            } else {
                resultBuilder.withMedicalOrSurgical(MsdrgMedSurgType.NONE);
            }
        } else {
            resultBuilder.withMedicalOrSurgical(MsdrgMedSurgType.NONE);
        }
        resultBuilder.withReturnCode(MsdrgGrouperReturnCode.OK);
        if (drg == 998) {
            resultBuilder.withSeverity(MsdrgSeverity.NONE);
        }
        return resultBuilder.build();
    }
}

