/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic;

import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import gov.agency.msdrg.model.enumeration.MsdrgCodeSeverityFlag;
import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.enumeration.MsdrgMedSurgType;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import java.util.List;

public class MsdrgUtility {
    public static MsdrgGrouperResult setUngroupable(MsdrgGrouperReturnCode returnCode, MsdrgInteractionDao dataAccess) {
        String baseDrgDescription = dataAccess.getBaseDrgDescription(999);
        String drgDescription = dataAccess.getDrgDescription(999);
        String mdcDescription = dataAccess.getMdcDescription(0);
        return MsdrgGrouperResult.builder().withDrg(999).withDrgDescription(drgDescription).withReturnCode(returnCode).withBaseDrg(999).withBaseDrgDescription(baseDrgDescription).withMdc(0).withMdcDescription(mdcDescription).withSeverity(MsdrgSeverity.NONE).withMedicalOrSurgical(MsdrgMedSurgType.NONE).build();
    }

    public static void resetFlags(List<MsdrgDiagnosisCode> sdxCodes, List<MsdrgProcedureCode> procedureCodes, boolean initialGrouping) {
        for (MsdrgDiagnosisCode dxCode : sdxCodes) {
            if (initialGrouping) {
                dxCode.setDrgImpact(MsdrgGroupingImpact.NONE);
                dxCode.setInitialMarked(false);
                continue;
            }
            if (dxCode.getDrgImpact().equals((Object)MsdrgGroupingImpact.BOTH)) {
                dxCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                dxCode.setFinalMarked(false);
                continue;
            }
            if (!dxCode.getDrgImpact().equals((Object)MsdrgGroupingImpact.FINAL)) continue;
            dxCode.setDrgImpact(MsdrgGroupingImpact.NONE);
            dxCode.setFinalMarked(false);
        }
        for (MsdrgProcedureCode procCode : procedureCodes) {
            if (initialGrouping) {
                procCode.setInitialMarked(false);
                procCode.setDrgImpact(MsdrgGroupingImpact.NONE);
                continue;
            }
            if (procCode.getDrgImpact().equals((Object)MsdrgGroupingImpact.BOTH)) {
                procCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                procCode.setFinalMarked(false);
                continue;
            }
            if (!procCode.getDrgImpact().equals((Object)MsdrgGroupingImpact.FINAL)) continue;
            procCode.setDrgImpact(MsdrgGroupingImpact.NONE);
            procCode.setFinalMarked(false);
        }
    }

    public static void resetSeverity(List<MsdrgDiagnosisCode> sdxCodes, boolean initialGrouping) {
        for (MsdrgDiagnosisCode dxCode : sdxCodes) {
            if (initialGrouping) {
                dxCode.setInitialSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
                continue;
            }
            dxCode.setFinalSeverityFlag(MsdrgCodeSeverityFlag.NEITHER);
        }
    }
}

