/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic.ast;

import com.mmm.his.cer.utility.farser.ast.node.type.BooleanExpression;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BilateralAstNode
implements BooleanExpression<Attribute> {
    private List<MsdrgProcedureCode> orderedCodes;
    private static Map<String, Attribute> bilateralAttributes = new HashMap<String, Attribute>();

    public BilateralAstNode(List<MsdrgProcedureCode> orderedCodes) {
        this.orderedCodes = orderedCodes;
    }

    @Override
    public boolean evaluate(List<Attribute> operands, Set<Attribute> accumulator) {
        HashSet<MsdrgProcedureCode> codesToMark = new HashSet<MsdrgProcedureCode>();
        HashMap<String, Attribute> bilaterals = new HashMap<String, Attribute>();
        for (MsdrgProcedureCode code : this.orderedCodes) {
            if (bilaterals.size() == 2) break;
            if (code.hasAttribute(bilateralAttributes.get("righthip"))) {
                bilaterals.put("righthip", bilateralAttributes.get("righthip"));
                codesToMark.add(code);
            }
            if (code.hasAttribute(bilateralAttributes.get("rightknee"))) {
                bilaterals.put("rightknee", bilateralAttributes.get("rightknee"));
                codesToMark.add(code);
            }
            if (code.hasAttribute(bilateralAttributes.get("rightankle"))) {
                bilaterals.put("rightankle", bilateralAttributes.get("rightankle"));
                codesToMark.add(code);
            }
            if (code.hasAttribute(bilateralAttributes.get("lefthip"))) {
                bilaterals.put("lefthip", bilateralAttributes.get("lefthip"));
                codesToMark.add(code);
            }
            if (code.hasAttribute(bilateralAttributes.get("leftknee"))) {
                bilaterals.put("leftknee", bilateralAttributes.get("leftknee"));
                codesToMark.add(code);
            }
            if (!code.hasAttribute(bilateralAttributes.get("leftankle"))) continue;
            bilaterals.put("leftankle", bilateralAttributes.get("leftankle"));
            codesToMark.add(code);
        }
        if (bilaterals.size() == 2) {
            accumulator.addAll(bilaterals.values());
            for (MsdrgProcedureCode procCode : codesToMark) {
                procCode.setBilateral(true);
            }
        }
        return bilaterals.size() == 2;
    }

    static {
        bilateralAttributes.put("righthip", new Attribute("righthip"));
        bilateralAttributes.put("rightknee", new Attribute("rightknee"));
        bilateralAttributes.put("rightankle", new Attribute("rightankle"));
        bilateralAttributes.put("lefthip", new Attribute("lefthip"));
        bilateralAttributes.put("leftknee", new Attribute("leftknee"));
        bilateralAttributes.put("leftankle", new Attribute("leftankle"));
    }

    public static class BilateralNodeSupplier
    implements NodeSupplier<DrgLexerToken, Attribute> {
        private List<MsdrgProcedureCode> orderedCodes;

        public void setOrderedCodes(List<MsdrgProcedureCode> orderedCodes) {
            this.orderedCodes = orderedCodes;
        }

        @Override
        public BooleanExpression<Attribute> createNode(DrgLexerToken token) {
            return new BilateralAstNode(this.orderedCodes);
        }
    }
}

