/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic.commonprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgMaskAttributes;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.RuntimeOptions;
import gov.agency.msdrg.model.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgChainContext;
import gov.agency.msdrg.model.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v390.ProcessingData;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import gov.agency.msdrg.v390.chain.Link;
import gov.agency.msdrg.v390.chain.ProcessingContext;
import gov.agency.msdrg.v390.logic.MsdrgFormulaEvaluation;
import gov.agency.msdrg.v390.logic.MsdrgMaskBuilder;
import gov.agency.msdrg.v390.logic.MsdrgUtility;
import gov.agency.msdrg.v390.logic.finalprocess.MsdrgFinalMarkingLogic;
import gov.agency.msdrg.v390.logic.initialprocess.MsdrgInitialMarkingLogic;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgPreMdcGrouping
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgPreMdcGrouping.class);
    private static final int PRE_MDC = 0;
    private static final String MCC_ALIVE = "MCCALIVE";
    private MsdrgInteractionDao dataAccess;

    @Override
    public boolean execute(ProcessingContext context) throws FoundationException {
        MsdrgGrouperResult grouperResult;
        boolean stopGrouping = false;
        this.dataAccess = (MsdrgInteractionDao)context.get(MsdrgChainContext.ACCESS);
        MsdrgMaskBuildingConditions condition = (MsdrgMaskBuildingConditions)((Object)context.get(MsdrgChainContext.GROUPING_TYPE));
        Map suppliers = (Map)context.get(MsdrgChainContext.AST_SUPPLIER_MAP);
        ProcessingData processingData = (ProcessingData)context.get(MsdrgChainContext.PROCESSING_DATA);
        for (MsdrgDiagnosisCode dxCode : processingData.getSdxCodes()) {
            if (dxCode.hasAttribute(MCC_ALIVE) && processingData.getDischargeStatus() == MsdrgDischargeStatus.NONE) {
                MsdrgGrouperResult grouperResult2 = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.INVALID_DISCHARGE_STATUS, this.dataAccess);
                ProcessingData data = processingData.toBuilder().withInitialResult(grouperResult2).withFinalResult(grouperResult2).build();
                context.put(MsdrgChainContext.PROCESSING_DATA, data);
                return false;
            }
            if (!dxCode.hasAttribute(MCC_ALIVE) || processingData.getDischargeStatus() != MsdrgDischargeStatus.DIED) continue;
            dxCode.setDeathExclusion(true);
        }
        logger.debug("Execute premdc grouping");
        RuntimeOptions runtimeOptions = (RuntimeOptions)context.get(MsdrgChainContext.RUNTIME_OPTIONS);
        MsdrgFormulaEvaluation.EvalContainer evalContainer = this.predMdcGrouping(processingData, condition, suppliers, runtimeOptions.getComputeAffectDrg(), runtimeOptions.getPoaReportingExempt());
        if (evalContainer == null) {
            throw new FoundationException("Formula evaluation failed.");
        }
        MsdrgMatchedDrgFormula matchedDrgFormula = evalContainer.getMatchedDrgFormula();
        MsdrgSeverity severity = evalContainer.getSeverity();
        ProcessingData.ProcessingDataBuilder processingDataBuilder = processingData.toBuilder();
        if (matchedDrgFormula.getFormula() != null && matchedDrgFormula.getFormula().contains("grc 7")) {
            grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.INVALID_PDX, this.dataAccess);
            processingDataBuilder.withInitialResult(grouperResult).withFinalResult(grouperResult);
            stopGrouping = true;
        }
        if (matchedDrgFormula.getFormula() != null && matchedDrgFormula.getFormula().contains("grc 1")) {
            grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.DX_CANNOT_BE_PDX, this.dataAccess);
            processingDataBuilder.withInitialResult(grouperResult).withFinalResult(grouperResult);
            stopGrouping = true;
        }
        if (matchedDrgFormula.getFormula() != null && matchedDrgFormula.getFormula().contains("grc 4")) {
            grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.INVALID_SEX, this.dataAccess);
            processingDataBuilder.withInitialResult(grouperResult).withFinalResult(grouperResult);
            stopGrouping = true;
        }
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            context.put(MsdrgChainContext.INITIAL_MATCHED_FORMULA, matchedDrgFormula);
            context.put(MsdrgChainContext.INITIAL_MDC, new LinkedList<Integer>(Collections.singleton(0)));
            processingData = processingDataBuilder.withInitialSeverity(severity).build();
            if (!matchedDrgFormula.isEmpty() && runtimeOptions.getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE) {
                MsdrgInitialMarkingLogic initialMarkingLogic = new MsdrgInitialMarkingLogic();
                processingData = initialMarkingLogic.initialMarking(matchedDrgFormula, processingData, 0);
            }
        } else if (condition == MsdrgMaskBuildingConditions.FINAL) {
            context.put(MsdrgChainContext.FINAL_MATCHED_FORMULA, matchedDrgFormula);
            context.put(MsdrgChainContext.FINAL_MDC, new LinkedList<Integer>(Collections.singletonList(0)));
            processingData = processingDataBuilder.withFinalSeverity(severity).build();
            if (!matchedDrgFormula.isEmpty() && runtimeOptions.getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE) {
                MsdrgFinalMarkingLogic finalMarkingLogic = new MsdrgFinalMarkingLogic();
                processingData = finalMarkingLogic.finalMarking(matchedDrgFormula, processingData, 0);
            }
        }
        context.put(MsdrgChainContext.PROCESSING_DATA, processingData);
        return !stopGrouping;
    }

    private MsdrgFormulaEvaluation.EvalContainer predMdcGrouping(ProcessingData processingData, MsdrgMaskBuildingConditions condition, Map<String, NodeSupplier<DrgLexerToken, Attribute>> suppliers, MsdrgAffectDrgOptionFlag computeAffectDrg, MsdrgHospitalStatusOptionFlag hospitalStatus) {
        int mdc = 0;
        logger.debug("Try grouping with mdc: {}", (Object)mdc);
        MsdrgMaskBuilder maskBuilder = new MsdrgMaskBuilder();
        MsdrgMaskAttributes mask = maskBuilder.buildMask(processingData);
        MsdrgFormulaEvaluation formulaEvaluation = new MsdrgFormulaEvaluation(this.dataAccess);
        formulaEvaluation.setSuppliers(suppliers);
        return formulaEvaluation.evaluateFormulas(processingData.getSdxCodes(), condition, mdc, mask, computeAffectDrg, hospitalStatus);
    }
}

