/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic.initialprocess;

import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import gov.agency.msdrg.model.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.enumeration.MsdrgSourceLogicLists;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v390.ProcessingData;
import gov.agency.msdrg.v390.logic.MsdrgUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class MsdrgInitialMarkingLogic {
    private static final Set<Integer> UNRELATED_DRGS = new HashSet<Integer>(Arrays.asList(981, 982, 983, 987, 988, 989));
    private static final Set<String> COMPLETE_SYSTEM = new HashSet<String>(Collections.singletonList("revision"));

    public ProcessingData initialMarking(MsdrgMatchedDrgFormula matchedFormula, ProcessingData processingData, int mdc) {
        MsdrgDiagnosisCode principalDx = processingData.getPrincipalDx();
        List<MsdrgDiagnosisCode> sdxCodes = processingData.getSdxCodes();
        List<MsdrgProcedureCode> procedureCodes = processingData.getProcedureCodes();
        List<MsdrgProcedureCode> clusters = processingData.getClusters();
        MsdrgProcedureCode principalProc = processingData.getPrincipalProc();
        if (UNRELATED_DRGS.contains(matchedFormula.getDrg())) {
            MsdrgUtility.resetFlags(sdxCodes, procedureCodes, true);
            mdc = 29;
        }
        this.markSpecialFunctionsDiagnosis(matchedFormula.getMatchedAttributes(), principalDx, sdxCodes);
        this.markSpecialFunctionsProcedure(matchedFormula.getMatchedAttributes(), procedureCodes);
        if (!procedureCodes.isEmpty()) {
            this.procedureMarkingLogic(matchedFormula, procedureCodes, clusters, mdc, principalProc);
        }
        if (!sdxCodes.isEmpty()) {
            this.diagnosisMarkingLogic(matchedFormula.getMatchedAttributes(), principalDx, sdxCodes);
        }
        MsdrgGrouperResult initialResult = processingData.getInitialResult();
        MsdrgGrouperReturnCode returnCode = null;
        if (initialResult != null) {
            returnCode = initialResult.getReturnCode();
        }
        if (returnCode == null || returnCode != MsdrgGrouperReturnCode.INVALID_DISCHARGE_STATUS && returnCode != MsdrgGrouperReturnCode.DX_CANNOT_BE_PDX && initialResult.getReturnCode() != MsdrgGrouperReturnCode.INVALID_PDX && initialResult.getReturnCode() != MsdrgGrouperReturnCode.INVALID_SEX) {
            principalDx.setDrgImpact(MsdrgGroupingImpact.INITIAL);
        }
        return processingData.toBuilder().withPdx(principalDx).withSdxCodes(sdxCodes).withProcedures(procedureCodes).withClusters(clusters).withPrincipalProcedure(principalProc).build();
    }

    private boolean multipleProcsHaveSameAttribute(Attribute attr, List<MsdrgProcedureCode> procCodes, int mdc) {
        int counter = 0;
        for (MsdrgProcedureCode procCode : procCodes) {
            if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
            ++counter;
        }
        return counter >= 2;
    }

    private boolean completeSystemTieBreaker(Attribute attr, List<MsdrgProcedureCode> procCodes, List<MsdrgProcedureCode> clusters, int mdc, MsdrgProcedureCode principalProc) {
        ArrayList<MsdrgProcedureCode> procCodesWithAttribute = new ArrayList<MsdrgProcedureCode>();
        ArrayList<MsdrgProcedureCode> clusterCodesWithAttribute = new ArrayList<MsdrgProcedureCode>();
        for (MsdrgProcedureCode procCode : procCodes) {
            if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
            procCodesWithAttribute.add(procCode);
        }
        for (MsdrgProcedureCode cluster : clusters) {
            if (!cluster.hasAttribute(attr)) continue;
            clusterCodesWithAttribute.add(cluster);
        }
        if (!procCodesWithAttribute.isEmpty() && !clusterCodesWithAttribute.isEmpty()) {
            if (principalProc.hasAttribute(attr)) {
                principalProc.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                principalProc.setInitialMarked(true);
                return true;
            }
            Iterator<MsdrgProcedureCode> iterator = procCodesWithAttribute.iterator();
            if (iterator.hasNext()) {
                MsdrgProcedureCode procCode;
                procCode = iterator.next();
                procCode.setInitialMarked(true);
                procCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                return true;
            }
        }
        return false;
    }

    private boolean operatingRoomTieBreaking(Attribute attr, List<MsdrgProcedureCode> procCodes, int mdc, MsdrgProcedureCode principalProc) {
        ArrayList<MsdrgProcedureCode> codesWithAttribute = new ArrayList<MsdrgProcedureCode>();
        for (MsdrgProcedureCode procCode : procCodes) {
            if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
            codesWithAttribute.add(procCode);
        }
        if (principalProc.hasAttribute(attr) && !principalProc.getMdcSuppression().get(mdc) && principalProc.isOperatingRoomProcedure()) {
            principalProc.setInitialMarked(true);
            principalProc.setDrgImpact(MsdrgGroupingImpact.INITIAL);
            return true;
        }
        for (MsdrgProcedureCode procCode : codesWithAttribute) {
            if (!procCode.isOperatingRoomProcedure()) continue;
            procCode.setInitialMarked(true);
            procCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
            return true;
        }
        return false;
    }

    private List<Attribute> getOnlyProcedureAttributes(MsdrgMatchedDrgFormula matchedAttr) {
        ArrayList<Attribute> procAttributes = new ArrayList<Attribute>();
        for (Attribute attr : matchedAttr.getMatchedAttributes()) {
            if (attr.getPrefix() != MsdrgAttributePrefix.NONE || attr.getListName().equals(MsdrgSeverity.MCC.name()) || attr.getListName().equals(MsdrgSeverity.CC.name()) || attr.getListName().equals(MsdrgSeverity.NON_CC.name())) continue;
            procAttributes.add(attr);
        }
        return procAttributes;
    }

    private boolean oneProcForAllAttributes(MsdrgMatchedDrgFormula matchedAttr, List<MsdrgProcedureCode> procCodes, List<MsdrgProcedureCode> clusterCodes, int mdc) {
        List<Attribute> procAttributes = this.getOnlyProcedureAttributes(matchedAttr);
        if (!procAttributes.isEmpty()) {
            for (MsdrgProcedureCode procCode : procCodes) {
                if (!procCode.isFirstPosition() || procCode.getMdcSuppression().get(mdc) || !procCode.getAttributes().containsAll(procAttributes)) continue;
                procCode.setInitialMarked(true);
                procCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                return true;
            }
            for (MsdrgProcedureCode procCode : procCodes) {
                if (procCode.getMdcSuppression().get(mdc) || !procCode.getAttributes().containsAll(procAttributes)) continue;
                procCode.setInitialMarked(true);
                procCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                return true;
            }
            for (MsdrgProcedureCode cluster : clusterCodes) {
                if (!cluster.getAttributes().containsAll(procAttributes)) continue;
                TreeSet<String> procValues = new TreeSet<String>();
                for (MsdrgProcedureCode procCode : procCodes) {
                    if (!procCode.getClusterIds().contains(cluster.getValue()) || procValues.contains(procCode.getValue())) continue;
                    procValues.add(procCode.getValue());
                    procCode.setInitialMarked(true);
                    procCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                }
                return true;
            }
        }
        return false;
    }

    private void procedureMarkingLogic(MsdrgMatchedDrgFormula matchedAttr, List<MsdrgProcedureCode> procCodes, List<MsdrgProcedureCode> clusterCodes, int mdc, MsdrgProcedureCode principalProcCode) {
        if (!this.oneProcForAllAttributes(matchedAttr, procCodes, clusterCodes, mdc)) {
            block0: for (Attribute attr : matchedAttr.getMatchedAttributes()) {
                if (COMPLETE_SYSTEM.contains(attr.getListName()) && this.completeSystemTieBreaker(attr, procCodes, clusterCodes, mdc, principalProcCode)) continue;
                if (this.multipleProcsHaveSameAttribute(attr, procCodes, mdc)) {
                    if (principalProcCode.hasAttribute(attr) && !principalProcCode.getMdcSuppression().get(mdc)) {
                        principalProcCode.setInitialMarked(true);
                        principalProcCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                        continue;
                    }
                    for (MsdrgProcedureCode procCode : procCodes) {
                        if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
                        procCode.setInitialMarked(true);
                        procCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                        continue block0;
                    }
                    continue;
                }
                boolean matchFound = false;
                for (MsdrgProcedureCode procCode : procCodes) {
                    if (!procCode.hasAttribute(attr) || procCode.getMdcSuppression().get(mdc)) continue;
                    procCode.setInitialMarked(true);
                    procCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                    matchFound = true;
                    break;
                }
                if (matchFound) continue;
                for (MsdrgProcedureCode cluster : clusterCodes) {
                    if (!cluster.hasAttribute(attr)) continue;
                    TreeSet<String> codeValues = new TreeSet<String>();
                    for (MsdrgProcedureCode procCode : procCodes) {
                        if (!procCode.getClusterIds().contains(cluster.getValue()) || codeValues.contains(procCode.getValue())) continue;
                        codeValues.add(procCode.getValue());
                        procCode.setInitialMarked(true);
                        procCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                    }
                    continue block0;
                }
            }
        }
    }

    private void diagnosisMarkingLogic(Set<Attribute> attr, MsdrgDiagnosisCode pdx, List<MsdrgDiagnosisCode> dxCodes) {
        TreeSet<Attribute> matchedAttributes = new TreeSet<Attribute>(attr);
        TreeSet<Attribute> attrToRemove = new TreeSet<Attribute>();
        for (MsdrgDiagnosisCode dxCode : dxCodes) {
            for (Attribute attribute : matchedAttributes) {
                if (dxCode.isInitialMarked() && dxCode.getAttributeMarkedFor() == attribute) {
                    attrToRemove.add(attribute);
                    break;
                }
                if (attribute.equals(new Attribute(MsdrgAttributePrefix.ONLY, "incident")) || pdx.hasAttribute(attribute.getListName()) && (attribute.getPrefix().equals((Object)MsdrgAttributePrefix.PDX) || attribute.getPrefix().equals((Object)MsdrgAttributePrefix.ANY))) continue;
                if ((attribute.getListName().equalsIgnoreCase("MCC") || attribute.getListName().equalsIgnoreCase("CC")) && !dxCode.isDowngradeSeverityDueToSuppression() && !dxCode.isExcluded() && dxCode.getSeverity().toString().equalsIgnoreCase(attribute.getListName())) {
                    dxCode.setInitialMarked(true);
                    dxCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                    dxCode.setAttributeMarkedFor(attribute);
                    attrToRemove.add(attribute);
                    break;
                }
                if (attribute.getPrefix() != MsdrgAttributePrefix.SDX && attribute.getPrefix() != MsdrgAttributePrefix.ANY || !dxCode.hasAttribute(attribute.getListName())) continue;
                dxCode.setInitialMarked(true);
                dxCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                dxCode.setAttributeMarkedFor(attribute);
                attrToRemove.add(attribute);
                break;
            }
            matchedAttributes.removeAll(attrToRemove);
        }
    }

    public void markSpecialFunctionsDiagnosis(Set<Attribute> matchedAttributes, MsdrgDiagnosisCode pdx, List<MsdrgDiagnosisCode> dxCodes) {
        this.markSigTrauma(matchedAttributes, dxCodes, pdx);
    }

    private void markSpecialFunctionsProcedure(Set<Attribute> matchedAttributes, List<MsdrgProcedureCode> procedureCodes) {
        this.markStents(matchedAttributes, procedureCodes);
        this.markVessels(matchedAttributes, procedureCodes);
    }

    private void markSigTrauma(Set<Attribute> matchedAttributes, List<MsdrgDiagnosisCode> dxCodes, MsdrgDiagnosisCode pdx) {
        int sigTraumaCounter = 0;
        if (pdx.isSigTrauma()) {
            pdx.setInitialMarked(true);
            pdx.setDrgImpact(MsdrgGroupingImpact.INITIAL);
            ++sigTraumaCounter;
        }
        if (matchedAttributes.contains(new Attribute("sthead")) || matchedAttributes.contains(new Attribute("stchest")) || matchedAttributes.contains(new Attribute("stabdom")) || matchedAttributes.contains(new Attribute("stkidney")) || matchedAttributes.contains(new Attribute("sturin")) || matchedAttributes.contains(new Attribute("stpel")) || matchedAttributes.contains(new Attribute("stuplimb")) || matchedAttributes.contains(new Attribute("stlolimb"))) {
            for (MsdrgDiagnosisCode dxCode : dxCodes) {
                if (!dxCode.isSigTrauma() || sigTraumaCounter >= 2) continue;
                dxCode.setInitialMarked(true);
                dxCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                ++sigTraumaCounter;
            }
            TreeSet<Attribute> attrs = new TreeSet<Attribute>();
            attrs.add(new Attribute("sthead"));
            attrs.add(new Attribute("stchest"));
            attrs.add(new Attribute("stabdom"));
            attrs.add(new Attribute("stkidney"));
            attrs.add(new Attribute("sturin"));
            attrs.add(new Attribute("stpel"));
            attrs.add(new Attribute("stuplimb"));
            attrs.add(new Attribute("stlolimb"));
            matchedAttributes.removeAll(attrs);
        }
    }

    private void markStents(Set<Attribute> matchedAttributes, List<MsdrgProcedureCode> procedureCodes) {
        HashSet<Attribute> attrs = new HashSet<Attribute>();
        attrs.add(new Attribute("stent1"));
        attrs.add(new Attribute("stent2"));
        attrs.add(new Attribute("stent3"));
        attrs.add(new Attribute("stent4"));
        attrs.add(new Attribute(MsdrgSourceLogicLists.NORDRUGSTENT.getValue()));
        attrs.add(new Attribute(MsdrgSourceLogicLists.NORSTENT.getValue()));
        attrs.add(new Attribute("arterial"));
        if (matchedAttributes.contains(new Attribute("stent1")) || matchedAttributes.contains(new Attribute("stent2")) || matchedAttributes.contains(new Attribute("stent3")) || matchedAttributes.contains(new Attribute("stent4"))) {
            for (MsdrgProcedureCode procCode : procedureCodes) {
                if (!procCode.isStents4()) continue;
                procCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                procCode.setInitialMarked(true);
            }
            if (matchedAttributes.contains(new Attribute("arterial")) && matchedAttributes.contains(new Attribute(MsdrgSourceLogicLists.NORDRUGSTENT.getValue()))) {
                for (MsdrgProcedureCode code : procedureCodes) {
                    if (code.isInitialMarked() || !code.hasAttribute(new Attribute("arterial")) || !code.hasAttribute(new Attribute(MsdrgSourceLogicLists.NORDRUGSTENT.getValue()))) continue;
                    code.setInitialMarked(true);
                    code.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                }
            } else if (matchedAttributes.contains(new Attribute("arterial")) && matchedAttributes.contains(new Attribute(MsdrgSourceLogicLists.NORSTENT.getValue()))) {
                for (MsdrgProcedureCode code : procedureCodes) {
                    if (code.isInitialMarked() || !code.hasAttribute(new Attribute("arterial")) || !code.hasAttribute(new Attribute(MsdrgSourceLogicLists.NORSTENT.getValue()))) continue;
                    code.setInitialMarked(true);
                    code.setDrgImpact(MsdrgGroupingImpact.INITIAL);
                }
            }
            matchedAttributes.removeAll(attrs);
        }
    }

    private void markVessels(Set<Attribute> matchedAttributes, List<MsdrgProcedureCode> procedureCodes) {
        if (matchedAttributes.contains(new Attribute("vessel1")) || matchedAttributes.contains(new Attribute("vessel2")) || matchedAttributes.contains(new Attribute("vessel3")) || matchedAttributes.contains(new Attribute("vessel4"))) {
            for (MsdrgProcedureCode procCode : procedureCodes) {
                if (!procCode.isVessels4()) continue;
                procCode.setInitialMarked(true);
                procCode.setDrgImpact(MsdrgGroupingImpact.INITIAL);
            }
            HashSet<Attribute> attrs = new HashSet<Attribute>();
            attrs.add(new Attribute("vessel1"));
            attrs.add(new Attribute("vessel2"));
            attrs.add(new Attribute("vessel3"));
            attrs.add(new Attribute("vessel4"));
            matchedAttributes.removeAll(attrs);
        }
    }
}

