/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v390.logic.preprocess;

import gov.agency.msdrg.model.ClusterChoices;
import gov.agency.msdrg.model.MsdrgCode;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import gov.agency.msdrg.model.enumeration.MsdrgChainContext;
import gov.agency.msdrg.model.transfer.MsdrgInputPrCode;
import gov.agency.msdrg.v390.ProcessingData;
import gov.agency.msdrg.v390.access.MsdrgInteractionDao;
import gov.agency.msdrg.v390.access.pojo.MsdrgClusterDefinition;
import gov.agency.msdrg.v390.chain.Link;
import gov.agency.msdrg.v390.chain.ProcessingContext;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgClusters
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgClusters.class);
    private MsdrgInteractionDao dbAccess;

    @Override
    public boolean execute(ProcessingContext context) {
        ProcessingData processingData = (ProcessingData)context.get(MsdrgChainContext.PROCESSING_DATA);
        this.dbAccess = (MsdrgInteractionDao)context.get(MsdrgChainContext.ACCESS);
        if (!processingData.getProcedureCodes().isEmpty()) {
            logger.debug("Begin processing of clusters");
            try {
                List<MsdrgProcedureCode> procClusters = this.processClusters(processingData);
                procClusters.sort(Comparator.comparing(MsdrgCode::getValue));
                ProcessingData updatedProcessingData = processingData.toBuilder().withClusters(procClusters).build();
                context.put(MsdrgChainContext.PROCESSING_DATA, updatedProcessingData);
            }
            catch (IOException | SQLException exception) {
                exception.printStackTrace();
            }
            logger.debug("Clusters finished");
        }
        return true;
    }

    private List<MsdrgProcedureCode> processClusters(ProcessingData data) throws SQLException, IOException {
        ArrayList<MsdrgProcedureCode> procClusters = new ArrayList<MsdrgProcedureCode>();
        logger.debug("Cluster ids retrieved from database");
        Set<MsdrgClusterDefinition> clusters = this.dbAccess.getClusters(data.getProcedureCodes().stream().map(MsdrgProcedureCode::getValue).collect(Collectors.toList()));
        block0: for (MsdrgClusterDefinition cluster : clusters) {
            ClusterChoices choices = cluster.getChoices();
            int choiceCount = choices.getChoiceCount();
            BitSet choiceTracker = new BitSet(choiceCount);
            HashSet<String> chosen = new HashSet<String>();
            for (MsdrgProcedureCode procedureCode : data.getProcedureCodes()) {
                Optional<Integer> contains = choices.contains(procedureCode.getValue());
                if (contains.isPresent()) {
                    int choiceNumber = contains.get() - 1;
                    choiceTracker.set(choiceNumber);
                    chosen.add(procedureCode.getValue());
                }
                if (choiceTracker.nextClearBit(0) < choiceCount) continue;
                MsdrgProcedureCode clusterCode = new MsdrgProcedureCode(new MsdrgInputPrCode(cluster.getClusterCode()));
                clusterCode.setMdcSuppression(cluster.getMdcRestrictions());
                procClusters.add(clusterCode);
                for (MsdrgProcedureCode msdrgProcedureCode : data.getProcedureCodes()) {
                    if (!chosen.contains(msdrgProcedureCode.getValue())) continue;
                    msdrgProcedureCode.setMdcSuppression(cluster.getMdcRestrictions());
                    msdrgProcedureCode.getClusterIds().add(cluster.getClusterCode());
                }
                continue block0;
            }
        }
        return procClusters;
    }
}

