/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391;

import com.mmm.his.cer.foundation.model.GfcPoa;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import gov.agency.msdrg.model.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.enumeration.MsdrgSex;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.model.transfer.MsdrgInputDxCode;
import gov.agency.msdrg.v391.MsdrgComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ProcessingData {
    private final MsdrgDiagnosisCode principalDx;
    private final MsdrgProcedureCode principalProc;
    private final MsdrgDiagnosisCode admitDx;
    private final List<MsdrgProcedureCode> clusters;
    private final List<MsdrgDiagnosisCode> sdxCodes;
    private final List<MsdrgProcedureCode> procedureCodes;
    private final MsdrgGrouperResult initialResult;
    private final MsdrgGrouperResult finalResult;
    private final MsdrgSeverity initialSeverity;
    private final MsdrgSeverity finalSeverity;
    private final MsdrgSex sex;
    private final MsdrgDischargeStatus dischargeStatus;

    public ProcessingData(MsdrgDiagnosisCode principalDx, List<MsdrgProcedureCode> clusters, List<MsdrgDiagnosisCode> sdxCodes, MsdrgProcedureCode principalProc, MsdrgDiagnosisCode admitDx, List<MsdrgProcedureCode> procedureCodes, MsdrgGrouperResult initialResult, MsdrgGrouperResult finalResult, MsdrgSeverity initialSeverity, MsdrgSeverity finalSeverity, MsdrgSex sex, MsdrgDischargeStatus dischargeStatus) {
        this.principalProc = principalProc;
        this.initialResult = initialResult;
        this.finalResult = finalResult;
        this.initialSeverity = initialSeverity;
        this.finalSeverity = finalSeverity;
        this.clusters = clusters != null ? Collections.unmodifiableList(new ArrayList<MsdrgProcedureCode>(clusters)) : new ArrayList<MsdrgProcedureCode>();
        this.sdxCodes = sdxCodes != null ? Collections.unmodifiableList(new ArrayList<MsdrgDiagnosisCode>(sdxCodes)) : new ArrayList<MsdrgDiagnosisCode>();
        this.procedureCodes = procedureCodes != null ? Collections.unmodifiableList(new ArrayList<MsdrgProcedureCode>(procedureCodes)) : new ArrayList<MsdrgProcedureCode>();
        this.admitDx = admitDx == null ? new MsdrgDiagnosisCode(new MsdrgInputDxCode(MsdrgComponent.NULL_CODE_VALUE, GfcPoa.N)) : admitDx;
        this.principalDx = principalDx == null ? new MsdrgDiagnosisCode(new MsdrgInputDxCode(MsdrgComponent.NULL_CODE_VALUE, GfcPoa.N)) : principalDx;
        this.sex = sex == null ? MsdrgSex.UNKNOWN : sex;
        this.dischargeStatus = dischargeStatus == null ? MsdrgDischargeStatus.NONE : dischargeStatus;
    }

    public MsdrgDiagnosisCode getPrincipalDx() {
        return this.principalDx;
    }

    public List<MsdrgDiagnosisCode> getSdxCodes() {
        return this.sdxCodes;
    }

    public List<MsdrgProcedureCode> getClusters() {
        return this.clusters;
    }

    public MsdrgProcedureCode getPrincipalProc() {
        return this.principalProc;
    }

    public MsdrgDiagnosisCode getAdmitDx() {
        return this.admitDx;
    }

    public List<MsdrgProcedureCode> getProcedureCodes() {
        return this.procedureCodes;
    }

    public MsdrgGrouperResult getInitialResult() {
        return this.initialResult;
    }

    public MsdrgGrouperResult getFinalResult() {
        return this.finalResult;
    }

    public MsdrgSeverity getInitialSeverity() {
        return this.initialSeverity;
    }

    public MsdrgSeverity getFinalSeverity() {
        return this.finalSeverity;
    }

    public MsdrgSex getSex() {
        return this.sex;
    }

    public MsdrgDischargeStatus getDischargeStatus() {
        return this.dischargeStatus;
    }

    public static ProcessingDataBuilder builder() {
        return new ProcessingDataBuilder();
    }

    public ProcessingDataBuilder toBuilder() {
        return new ProcessingDataBuilder(this);
    }

    public static final class ProcessingDataBuilder {
        private MsdrgProcedureCode principalProc;
        private MsdrgDiagnosisCode admitDx;
        private List<MsdrgProcedureCode> clusters;
        private List<MsdrgDiagnosisCode> sdxCodes;
        private List<MsdrgProcedureCode> procedureCodes;
        private MsdrgDiagnosisCode principalDx;
        private MsdrgGrouperResult initialResult;
        private MsdrgGrouperResult finalResult;
        private MsdrgSeverity initialSeverity;
        private MsdrgSeverity finalSeverity;
        private MsdrgSex sex;
        private MsdrgDischargeStatus dischargeStatus;

        private ProcessingDataBuilder() {
        }

        public ProcessingDataBuilder(ProcessingData other) {
            this.principalProc = other.principalProc;
            this.admitDx = other.admitDx;
            this.clusters = other.clusters;
            this.sdxCodes = other.sdxCodes;
            this.procedureCodes = other.procedureCodes;
            this.principalDx = other.principalDx;
            this.initialResult = other.initialResult;
            this.finalResult = other.finalResult;
            this.initialSeverity = other.initialSeverity;
            this.finalSeverity = other.finalSeverity;
            this.sex = other.sex;
            this.dischargeStatus = other.dischargeStatus;
        }

        public ProcessingDataBuilder withPdx(MsdrgDiagnosisCode pdx) {
            this.principalDx = pdx;
            return this;
        }

        public ProcessingDataBuilder withClusters(List<MsdrgProcedureCode> clusters) {
            this.clusters = clusters;
            return this;
        }

        public ProcessingDataBuilder withSdxCodes(List<MsdrgDiagnosisCode> sdxCodes) {
            this.sdxCodes = sdxCodes;
            return this;
        }

        public ProcessingDataBuilder withPrincipalProcedure(MsdrgProcedureCode msdrgProcedureCode) {
            this.principalProc = msdrgProcedureCode;
            return this;
        }

        public ProcessingDataBuilder withAdmitDx(MsdrgDiagnosisCode admitDx) {
            this.admitDx = admitDx;
            return this;
        }

        public ProcessingDataBuilder withProcedures(List<MsdrgProcedureCode> procedureCodes) {
            this.procedureCodes = procedureCodes;
            return this;
        }

        public ProcessingDataBuilder withInitialResult(MsdrgGrouperResult initialResult) {
            this.initialResult = initialResult;
            return this;
        }

        public ProcessingDataBuilder withFinalResult(MsdrgGrouperResult finalResult) {
            this.finalResult = finalResult;
            return this;
        }

        public ProcessingDataBuilder withInitialSeverity(MsdrgSeverity severity) {
            this.initialSeverity = severity;
            return this;
        }

        public ProcessingDataBuilder withFinalSeverity(MsdrgSeverity severity) {
            this.finalSeverity = severity;
            return this;
        }

        public ProcessingDataBuilder withSex(MsdrgSex sex) {
            this.sex = sex;
            return this;
        }

        public ProcessingDataBuilder withDischargeStatus(MsdrgDischargeStatus dischargeStatus) {
            this.dischargeStatus = dischargeStatus;
            return this;
        }

        public ProcessingData build() {
            return new ProcessingData(this.principalDx, this.clusters, this.sdxCodes, this.principalProc, this.admitDx, this.procedureCodes, this.initialResult, this.finalResult, this.initialSeverity, this.finalSeverity, this.sex, this.dischargeStatus);
        }
    }
}

