/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.access.dao;

import gov.agency.msdrg.model.MsdrgHac;
import gov.agency.msdrg.v391.access.blob.DataAccess;
import gov.agency.msdrg.v391.access.dao.DescriptionAccess;
import gov.agency.msdrg.v391.access.dao.structure.CodeDao;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class CodeAccess
implements CodeDao {
    protected final DataAccess dataAccess;
    protected final DescriptionAccess descriptionAccess;

    public CodeAccess(DataAccess dataAccess) {
        this.dataAccess = dataAccess;
        this.descriptionAccess = new DescriptionAccess(dataAccess);
    }

    @Override
    public boolean isCodeValid(String code) {
        return this.dataAccess.isCodeValid(code);
    }

    @Override
    public boolean isCodeOnGenderList(String code) {
        Map<Integer, Integer> genderMdcs = this.dataAccess.getCodeGenderMdcs(code);
        return !genderMdcs.isEmpty();
    }

    @Override
    public List<MsdrgHac> getHacsForCode(String code) {
        List<String> hacOperands = this.dataAccess.getHacOperands(code);
        List<Integer> hacNumbers = this.dataAccess.getHacNumbers(code);
        HashSet<Integer> distinctHacNumbers = new HashSet<Integer>(hacNumbers);
        ArrayList<MsdrgHac> returnList = new ArrayList<MsdrgHac>();
        for (int i = 0; i < distinctHacNumbers.size(); ++i) {
            Integer hacNumber = hacNumbers.get(i);
            MsdrgHac hac = new MsdrgHac();
            hac.setHacList(hacOperands.get(i));
            hac.setHacNumber(hacNumber);
            this.descriptionAccess.getHacDescription(hacNumber).ifPresent(hac::setDescription);
            returnList.add(hac);
        }
        return returnList;
    }
}

