/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.chain;

import gov.agency.msdrg.v391.access.blob.DataAccess;
import gov.agency.msdrg.v391.access.dao.ClusterAccess;
import gov.agency.msdrg.v391.access.dao.DescriptionAccess;
import gov.agency.msdrg.v391.access.dao.DiagnosisAccess;
import gov.agency.msdrg.v391.access.dao.ExclusionAccess;
import gov.agency.msdrg.v391.access.dao.FormulaAccess;
import gov.agency.msdrg.v391.access.dao.ProcedureAccess;
import gov.agency.msdrg.v391.chain.Link;
import gov.agency.msdrg.v391.logic.MsdrgHacProcessor;
import gov.agency.msdrg.v391.logic.commonprocess.MsdrgMdcRerouteGrouping;
import gov.agency.msdrg.v391.logic.commonprocess.MsdrgPdxMdcGrouping;
import gov.agency.msdrg.v391.logic.commonprocess.MsdrgPreMdcGrouping;
import gov.agency.msdrg.v391.logic.finalprocess.MsdrgFinalDrgResults;
import gov.agency.msdrg.v391.logic.finalprocess.MsdrgFinalGrouping;
import gov.agency.msdrg.v391.logic.initialprocess.MsdrgInitialDrgResults;
import gov.agency.msdrg.v391.logic.initialprocess.MsdrgInitialGrouping;
import gov.agency.msdrg.v391.logic.preprocess.MsdrgClusters;
import gov.agency.msdrg.v391.logic.preprocess.MsdrgExclusions;
import gov.agency.msdrg.v391.logic.preprocess.PdxAttributeProcessor;
import gov.agency.msdrg.v391.logic.preprocess.ProcedureAttributeProcessor;
import gov.agency.msdrg.v391.logic.preprocess.SdxAttributeProcessor;
import java.util.stream.Stream;

public class GrouperChain {
    private GrouperChain() {
    }

    public static Link createChain(DataAccess access) {
        DiagnosisAccess diagnosisDao = new DiagnosisAccess(access);
        ProcedureAccess procedureDao = new ProcedureAccess(access);
        DescriptionAccess descriptionDao = new DescriptionAccess(access);
        ExclusionAccess exclusionDao = new ExclusionAccess(access);
        FormulaAccess formulaDao = new FormulaAccess(access);
        ClusterAccess clusterDao = new ClusterAccess(access);
        Link preprocessingLink = Stream.of(new MsdrgClusters(clusterDao), new ProcedureAttributeProcessor(procedureDao), new MsdrgExclusions(exclusionDao), new SdxAttributeProcessor(diagnosisDao), new PdxAttributeProcessor(diagnosisDao, descriptionDao)).reduce((current, before) -> before.compose((Link)current)).orElse(context -> new Link.LinkResult(context, false));
        Link commonGroupingLink = Stream.of(new MsdrgPreMdcGrouping(formulaDao, descriptionDao), new MsdrgMdcRerouteGrouping(descriptionDao, formulaDao), new MsdrgPdxMdcGrouping(formulaDao, descriptionDao), new MsdrgMdcRerouteGrouping(descriptionDao, formulaDao)).reduce((current, before) -> before.compose((Link)current)).orElse(context -> new Link.LinkResult(context, false));
        Link initialGroupingLink = Stream.of(new MsdrgInitialGrouping(), commonGroupingLink, new MsdrgInitialDrgResults(descriptionDao)).reduce((current, before) -> before.compose((Link)current)).orElse(context -> new Link.LinkResult(context, false));
        Link finalGroupingLink = Stream.of(new MsdrgFinalGrouping(), commonGroupingLink, new MsdrgFinalDrgResults(descriptionDao)).reduce((current, before) -> before.compose((Link)current)).orElse(context -> new Link.LinkResult(context, false));
        return Stream.of(preprocessingLink, initialGroupingLink, new MsdrgHacProcessor(descriptionDao, formulaDao), finalGroupingLink).reduce((current, before) -> before.compose((Link)current)).orElse(context -> new Link.LinkResult(context, false));
    }
}

