/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.chain;

import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.RuntimeOptions;
import gov.agency.msdrg.model.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.v391.ProcessingData;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class ProcessingContext {
    private final Map<String, NodeSupplier<DrgLexerToken, Attribute>> supplierMap;
    private final RuntimeOptions runtime;
    private final ProcessingData processingData;
    private final MsdrgMaskBuildingConditions groupingType;
    private final MsdrgMatchedDrgFormula initialMatchedFormula;
    private final MsdrgMatchedDrgFormula finalMatchedFormula;
    private final LinkedList<Integer> initialMdc;
    private final LinkedList<Integer> finalMdc;

    private ProcessingContext(Map<String, NodeSupplier<DrgLexerToken, Attribute>> supplierMap, RuntimeOptions runtime, ProcessingData processingData, MsdrgMaskBuildingConditions groupingType, MsdrgMatchedDrgFormula initialMatchedFormula, MsdrgMatchedDrgFormula finalMatchedFormula, List<Integer> initialMdc, List<Integer> finalMdc) {
        this.supplierMap = new HashMap<String, NodeSupplier<DrgLexerToken, Attribute>>(supplierMap);
        this.runtime = runtime;
        this.processingData = processingData;
        this.groupingType = groupingType;
        this.initialMatchedFormula = initialMatchedFormula;
        this.finalMatchedFormula = finalMatchedFormula;
        this.initialMdc = initialMdc == null ? new LinkedList() : new LinkedList<Integer>(initialMdc);
        this.finalMdc = finalMdc == null ? new LinkedList() : new LinkedList<Integer>(finalMdc);
    }

    public static ProcessingContextBuilder builder() {
        return new ProcessingContextBuilder();
    }

    public ProcessingContextBuilder toBuilder() {
        return new ProcessingContextBuilder(this);
    }

    public Map<String, NodeSupplier<DrgLexerToken, Attribute>> getSupplierMap() {
        return Collections.unmodifiableMap(this.supplierMap);
    }

    public RuntimeOptions getRuntime() {
        return this.runtime;
    }

    public ProcessingData getProcessingData() {
        return this.processingData;
    }

    public Optional<MsdrgMaskBuildingConditions> getGroupingType() {
        return Optional.ofNullable(this.groupingType);
    }

    public Optional<MsdrgMatchedDrgFormula> getInitialMatchedFormula() {
        return Optional.ofNullable(this.initialMatchedFormula);
    }

    public Optional<MsdrgMatchedDrgFormula> getFinalMatchedFormula() {
        return Optional.ofNullable(this.finalMatchedFormula);
    }

    public LinkedList<Integer> getInitialMdc() {
        return new LinkedList<Integer>(this.initialMdc);
    }

    public LinkedList<Integer> getFinalMdc() {
        return new LinkedList<Integer>(this.finalMdc);
    }

    public static final class ProcessingContextBuilder {
        private Map<String, NodeSupplier<DrgLexerToken, Attribute>> supplierMap = new HashMap<String, NodeSupplier<DrgLexerToken, Attribute>>();
        private RuntimeOptions runtime;
        private ProcessingData processingData;
        private MsdrgMaskBuildingConditions groupingType;
        private MsdrgMatchedDrgFormula initialMatchedFormula;
        private MsdrgMatchedDrgFormula finalMatchedFormula;
        private List<Integer> initialMdc;
        private List<Integer> finalMdc;

        private ProcessingContextBuilder() {
        }

        private ProcessingContextBuilder(ProcessingContext other) {
            this.supplierMap = other.supplierMap;
            this.runtime = other.runtime;
            this.processingData = other.processingData;
            this.groupingType = other.groupingType;
            this.initialMatchedFormula = other.initialMatchedFormula;
            this.finalMatchedFormula = other.finalMatchedFormula;
            this.initialMdc = other.initialMdc;
            this.finalMdc = other.finalMdc;
        }

        public ProcessingContextBuilder withSupplierMap(Map<String, NodeSupplier<DrgLexerToken, Attribute>> supplierMap) {
            this.supplierMap = supplierMap;
            return this;
        }

        public ProcessingContextBuilder withRuntime(RuntimeOptions runtime) {
            this.runtime = runtime;
            return this;
        }

        public ProcessingContextBuilder withProcessingData(ProcessingData processingData) {
            this.processingData = processingData;
            return this;
        }

        public ProcessingContextBuilder withGroupingType(MsdrgMaskBuildingConditions groupingType) {
            this.groupingType = groupingType;
            return this;
        }

        public ProcessingContextBuilder withInitialMatchedFormula(MsdrgMatchedDrgFormula initialMatchedFormula) {
            this.initialMatchedFormula = initialMatchedFormula;
            return this;
        }

        public ProcessingContextBuilder withFinalMatchedFormula(MsdrgMatchedDrgFormula finalMatchedFormula) {
            this.finalMatchedFormula = finalMatchedFormula;
            return this;
        }

        public ProcessingContextBuilder withInitialMdc(LinkedList<Integer> initialMdc) {
            this.initialMdc = initialMdc;
            return this;
        }

        public ProcessingContextBuilder withFinalMdc(LinkedList<Integer> finalMdc) {
            this.finalMdc = finalMdc;
            return this;
        }

        public ProcessingContext build() {
            return new ProcessingContext(this.supplierMap, this.runtime, this.processingData, this.groupingType, this.initialMatchedFormula, this.finalMatchedFormula, this.initialMdc, this.finalMdc);
        }
    }
}

