/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic.ast;

import com.mmm.his.cer.utility.farser.ast.node.type.BooleanExpression;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgProcedureCode;
import gov.agency.msdrg.model.enumeration.MsdrgSourceLogicLists;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DrugEludingStentAstNode
implements BooleanExpression<Attribute> {
    private static final String STENT1 = "stent1";
    private static final String STENT2 = "stent2";
    private static final String STENT3 = "stent3";
    private static final String STENT4 = "stent4";
    private List<MsdrgProcedureCode> orderedCodes;
    private static Map<String, Attribute> stentAttributes = new HashMap<String, Attribute>();

    public DrugEludingStentAstNode(List<MsdrgProcedureCode> orderedCodes) {
        this.orderedCodes = orderedCodes;
    }

    @Override
    public boolean evaluate(List<Attribute> operands, Set<Attribute> accumulator) {
        HashSet<MsdrgProcedureCode> codesToMark = new HashSet<MsdrgProcedureCode>();
        HashMap<String, Attribute> stents = new HashMap<String, Attribute>();
        int count = 0;
        for (MsdrgProcedureCode code : this.orderedCodes) {
            if (count >= 4) break;
            if (code.hasAttribute(stentAttributes.get(STENT1)) && code.hasAttribute(new Attribute(MsdrgSourceLogicLists.NORDRUGSTENT.getValue()))) {
                stents.put(STENT1, stentAttributes.get(STENT1));
                codesToMark.add(code);
                ++count;
                continue;
            }
            if (code.hasAttribute(stentAttributes.get(STENT2)) && code.hasAttribute(new Attribute(MsdrgSourceLogicLists.NORDRUGSTENT.getValue()))) {
                stents.put(STENT2, stentAttributes.get(STENT2));
                codesToMark.add(code);
                count += 2;
                continue;
            }
            if (code.hasAttribute(stentAttributes.get(STENT3)) && code.hasAttribute(new Attribute(MsdrgSourceLogicLists.NORDRUGSTENT.getValue()))) {
                stents.put(STENT3, stentAttributes.get(STENT3));
                codesToMark.add(code);
                count += 3;
                continue;
            }
            if (!code.hasAttribute(stentAttributes.get(STENT4)) || !code.hasAttribute(new Attribute(MsdrgSourceLogicLists.NORDRUGSTENT.getValue()))) continue;
            stents.put(STENT4, stentAttributes.get(STENT4));
            codesToMark.add(code);
            count += 4;
        }
        if (count >= 4) {
            accumulator.addAll(stents.values());
            for (MsdrgProcedureCode code : codesToMark) {
                code.setStents4(true);
            }
            return true;
        }
        return false;
    }

    static {
        stentAttributes.put(STENT1, new Attribute(STENT1));
        stentAttributes.put(STENT2, new Attribute(STENT2));
        stentAttributes.put(STENT3, new Attribute(STENT3));
        stentAttributes.put(STENT4, new Attribute(STENT4));
    }

    public static class DrugEludingNodeSupplier
    implements NodeSupplier<DrgLexerToken, Attribute> {
        private List<MsdrgProcedureCode> orderedCodes;

        public void setOrderedCodes(List<MsdrgProcedureCode> orderedCodes) {
            this.orderedCodes = orderedCodes;
        }

        @Override
        public BooleanExpression<Attribute> createNode(DrgLexerToken token) {
            return new DrugEludingStentAstNode(this.orderedCodes);
        }
    }
}

