/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic.ast;

import com.mmm.his.cer.utility.farser.ast.node.type.BooleanExpression;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SigTraumaAstNode
implements BooleanExpression<Attribute> {
    private MsdrgDiagnosisCode pdx;
    private List<MsdrgDiagnosisCode> orderedCodes;
    private static Map<String, Attribute> sigTraumaAttributes = new HashMap<String, Attribute>();

    public SigTraumaAstNode(MsdrgDiagnosisCode pdx, List<MsdrgDiagnosisCode> orderedCodes) {
        this.orderedCodes = orderedCodes;
        this.pdx = pdx;
    }

    @Override
    public boolean evaluate(List<Attribute> operands, Set<Attribute> accumulator) {
        ArrayList<MsdrgDiagnosisCode> codes = new ArrayList<MsdrgDiagnosisCode>();
        codes.add(this.pdx);
        codes.addAll(this.orderedCodes);
        HashMap<String, Attribute> sigTraumas = new HashMap<String, Attribute>();
        HashSet<MsdrgDiagnosisCode> codesToMark = new HashSet<MsdrgDiagnosisCode>();
        for (MsdrgDiagnosisCode code : codes) {
            if (sigTraumas.size() == 2) break;
            if (code.hasAttribute("sthead")) {
                sigTraumas.put("sthead", sigTraumaAttributes.get("sthead"));
                codesToMark.add(code);
            }
            if (code.hasAttribute("stchest")) {
                sigTraumas.put("stchest", sigTraumaAttributes.get("stchest"));
                codesToMark.add(code);
            }
            if (code.hasAttribute("stabdom")) {
                sigTraumas.put("stabdom", sigTraumaAttributes.get("stabdom"));
                codesToMark.add(code);
            }
            if (code.hasAttribute("stkidney")) {
                sigTraumas.put("stkidney", sigTraumaAttributes.get("stkidney"));
                codesToMark.add(code);
            }
            if (code.hasAttribute("sturin")) {
                sigTraumas.put("sturin", sigTraumaAttributes.get("sturin"));
                codesToMark.add(code);
            }
            if (code.hasAttribute("stpel")) {
                sigTraumas.put("stpel", sigTraumaAttributes.get("stpel"));
                codesToMark.add(code);
            }
            if (code.hasAttribute("stuplimb")) {
                sigTraumas.put("stuplimb", sigTraumaAttributes.get("stuplimb"));
                codesToMark.add(code);
            }
            if (code.hasAttribute("stlolimb")) {
                sigTraumas.put("stlolimb", sigTraumaAttributes.get("stlolimb"));
                codesToMark.add(code);
            }
            if (sigTraumas.size() != 2) continue;
            accumulator.addAll(sigTraumas.values());
            for (MsdrgDiagnosisCode dxCode : codesToMark) {
                dxCode.setSigTrauma(true);
            }
        }
        return sigTraumas.size() == 2;
    }

    static {
        sigTraumaAttributes.put("sthead", new Attribute("sthead"));
        sigTraumaAttributes.put("stchest", new Attribute("stchest"));
        sigTraumaAttributes.put("stabdom", new Attribute("stabdom"));
        sigTraumaAttributes.put("stkidney", new Attribute("stkidney"));
        sigTraumaAttributes.put("sturin", new Attribute("sturin"));
        sigTraumaAttributes.put("stpel", new Attribute("stpel"));
        sigTraumaAttributes.put("stuplimb", new Attribute("stuplimb"));
        sigTraumaAttributes.put("stlolimb", new Attribute("stlolimb"));
    }

    public static class SigTraumaNodeSupplier
    implements NodeSupplier<DrgLexerToken, Attribute> {
        private List<MsdrgDiagnosisCode> orderedCodes;
        private MsdrgDiagnosisCode pdx;

        public void setOrderedCodes(MsdrgDiagnosisCode pdx, List<MsdrgDiagnosisCode> orderedCodes) {
            this.pdx = pdx;
            this.orderedCodes = orderedCodes;
        }

        @Override
        public BooleanExpression<Attribute> createNode(DrgLexerToken token) {
            return new SigTraumaAstNode(this.pdx, this.orderedCodes);
        }
    }
}

