/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic.commonprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import com.mmm.his.cer.foundation.exception.FoundationRuntimeException;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgMaskAttributes;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.RuntimeOptions;
import gov.agency.msdrg.model.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.enumeration.MsdrgHospitalStatusOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v391.ProcessingData;
import gov.agency.msdrg.v391.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v391.access.dao.structure.FormulaDao;
import gov.agency.msdrg.v391.chain.Link;
import gov.agency.msdrg.v391.chain.ProcessingContext;
import gov.agency.msdrg.v391.logic.MsdrgFormulaEvaluation;
import gov.agency.msdrg.v391.logic.MsdrgMaskBuilder;
import gov.agency.msdrg.v391.logic.MsdrgUtility;
import gov.agency.msdrg.v391.logic.finalprocess.MsdrgFinalMarkingLogic;
import gov.agency.msdrg.v391.logic.initialprocess.MsdrgInitialMarkingLogic;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgMdcRerouteGrouping
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgMdcRerouteGrouping.class);
    private final DescriptionDao descriptionAccess;
    private final FormulaDao formulaAccess;
    private static final String GRC_5 = "grc 5";

    public MsdrgMdcRerouteGrouping(DescriptionDao descriptionAccess, FormulaDao formulaAccess) {
        this.descriptionAccess = descriptionAccess;
        this.formulaAccess = formulaAccess;
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        MsdrgMaskBuildingConditions condition = context.getGroupingType().orElse(MsdrgMaskBuildingConditions.NONE);
        Optional<MsdrgMatchedDrgFormula> maybeMatchedFormula = condition == MsdrgMaskBuildingConditions.INITIAL ? context.getInitialMatchedFormula() : context.getFinalMatchedFormula();
        MsdrgMatchedDrgFormula matchedFormula = maybeMatchedFormula.orElseThrow(() -> new FoundationRuntimeException("No matched formula cannot perform reroute grouping"));
        if (matchedFormula.getReRouteMdcId() == 0) {
            return new Link.LinkResult(context, true);
        }
        Map<String, NodeSupplier<DrgLexerToken, Attribute>> suppliers = context.getSupplierMap();
        LinkedList<Integer> initialMdcs = new LinkedList<Integer>(context.getInitialMdc());
        LinkedList<Integer> finalMdcs = new LinkedList<Integer>(context.getFinalMdc());
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            initialMdcs.add(matchedFormula.getReRouteMdcId());
        } else if (condition == MsdrgMaskBuildingConditions.FINAL) {
            finalMdcs.add(matchedFormula.getReRouteMdcId());
        }
        ProcessingData processingData = context.getProcessingData();
        RuntimeOptions runtimeOptions = context.getRuntime();
        MsdrgFormulaEvaluation.EvalContainer evalContainer = this.rerouteGrouping(processingData, condition, matchedFormula, suppliers, runtimeOptions.getComputeAffectDrg(), runtimeOptions.getPoaReportingExempt());
        if (evalContainer == null) {
            throw new FoundationException("Formula evaluation failed.");
        }
        MsdrgMatchedDrgFormula newMatchedFormula = evalContainer.getMatchedDrgFormula();
        MsdrgSeverity severity = evalContainer.getSeverity();
        if (newMatchedFormula.getReRouteMdcId() != 0) {
            evalContainer = this.rerouteGrouping(processingData = this.rerouteMarking(processingData, runtimeOptions, condition, newMatchedFormula, newMatchedFormula.getReRouteMdcId()), condition, newMatchedFormula, suppliers, runtimeOptions.getComputeAffectDrg(), runtimeOptions.getPoaReportingExempt());
            if (evalContainer != null) {
                newMatchedFormula = evalContainer.getMatchedDrgFormula();
            } else {
                throw new FoundationException("Formula evaluation failed.");
            }
        }
        if (matchedFormula.getFormula() != null && matchedFormula.getFormula().contains(GRC_5)) {
            MsdrgGrouperResult grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.INVALID_DISCHARGE_STATUS, this.descriptionAccess);
            processingData.getSdxCodes().forEach(code -> code.setSeverityFlag(condition));
            context = context.toBuilder().withProcessingData(processingData.toBuilder().withFinalResult(grouperResult).withInitialResult(grouperResult).build()).build();
            return new Link.LinkResult(context, false);
        }
        processingData = this.rerouteMarking(processingData, runtimeOptions, condition, newMatchedFormula, matchedFormula.getReRouteMdcId());
        ProcessingContext.ProcessingContextBuilder contextBuilder = context.toBuilder();
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            contextBuilder.withInitialMatchedFormula(newMatchedFormula);
            processingData = processingData.toBuilder().withInitialSeverity(severity).build();
        } else if (condition == MsdrgMaskBuildingConditions.FINAL) {
            contextBuilder.withFinalMatchedFormula(newMatchedFormula);
            processingData = processingData.toBuilder().withFinalSeverity(severity).build();
        }
        contextBuilder.withInitialMdc(initialMdcs).withFinalMdc(finalMdcs).withProcessingData(processingData);
        return new Link.LinkResult(contextBuilder.build(), true);
    }

    private ProcessingData rerouteMarking(ProcessingData processingData, RuntimeOptions runtimeOptions, MsdrgMaskBuildingConditions condition, MsdrgMatchedDrgFormula matchedFormula, int mdc) {
        ProcessingData data = ProcessingData.builder().build();
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            if (!matchedFormula.isEmpty() && runtimeOptions.getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE) {
                MsdrgInitialMarkingLogic initialMarkingLogic = new MsdrgInitialMarkingLogic();
                data = initialMarkingLogic.initialMarking(matchedFormula, processingData, mdc);
            }
        } else if (condition == MsdrgMaskBuildingConditions.FINAL && !matchedFormula.isEmpty() && runtimeOptions.getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE) {
            MsdrgFinalMarkingLogic finalMarkingLogic = new MsdrgFinalMarkingLogic();
            data = finalMarkingLogic.finalMarking(matchedFormula, processingData, mdc);
        }
        return data;
    }

    private MsdrgFormulaEvaluation.EvalContainer rerouteGrouping(ProcessingData processingData, MsdrgMaskBuildingConditions condition, MsdrgMatchedDrgFormula matchedFormula, Map<String, NodeSupplier<DrgLexerToken, Attribute>> suppliers, MsdrgAffectDrgOptionFlag computeAffectDrg, MsdrgHospitalStatusOptionFlag hospitalStatus) {
        int mdc = matchedFormula.getReRouteMdcId();
        logger.debug("Reroute logic");
        MsdrgMaskBuilder maskBuilder = new MsdrgMaskBuilder();
        MsdrgMaskAttributes mask = maskBuilder.buildMask(processingData);
        logger.debug("Try grouping with mdc: {}", (Object)mdc);
        MsdrgFormulaEvaluation formulaEvaluation = new MsdrgFormulaEvaluation(this.formulaAccess);
        formulaEvaluation.setSuppliers(suppliers);
        return formulaEvaluation.evaluateFormulas(processingData.getSdxCodes(), condition, mdc, mask, computeAffectDrg, hospitalStatus);
    }
}

