/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic.commonprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import com.mmm.his.cer.foundation.exception.FoundationRuntimeException;
import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.MsdrgMaskAttributes;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.RuntimeOptions;
import gov.agency.msdrg.model.enumeration.MsdrgAffectDrgOptionFlag;
import gov.agency.msdrg.model.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.enumeration.MsdrgMaskBuildingConditions;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v391.ProcessingData;
import gov.agency.msdrg.v391.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v391.access.dao.structure.FormulaDao;
import gov.agency.msdrg.v391.chain.Link;
import gov.agency.msdrg.v391.chain.ProcessingContext;
import gov.agency.msdrg.v391.logic.MsdrgFormulaEvaluation;
import gov.agency.msdrg.v391.logic.MsdrgMaskBuilder;
import gov.agency.msdrg.v391.logic.MsdrgUtility;
import gov.agency.msdrg.v391.logic.finalprocess.MsdrgFinalMarkingLogic;
import gov.agency.msdrg.v391.logic.initialprocess.MsdrgInitialMarkingLogic;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgPreMdcGrouping
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgPreMdcGrouping.class);
    private static final int PRE_MDC = 0;
    private static final String MCC_ALIVE = "MCCALIVE";
    private static final String GRC_1 = "grc 1";
    private static final String GRC_4 = "grc 4";
    private static final String GRC_7 = "grc 7";
    private final FormulaDao formulaAccess;
    private final DescriptionDao descriptionAccess;

    public MsdrgPreMdcGrouping(FormulaDao formulaAccess, DescriptionDao descriptionAccess) {
        this.formulaAccess = formulaAccess;
        this.descriptionAccess = descriptionAccess;
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        MsdrgGrouperResult grouperResult;
        boolean stopGrouping = false;
        ProcessingData processingData = context.getProcessingData();
        for (MsdrgDiagnosisCode dxCode : processingData.getSdxCodes()) {
            if (dxCode.hasAttribute(MCC_ALIVE) && processingData.getDischargeStatus() == MsdrgDischargeStatus.NONE) {
                MsdrgGrouperResult grouperResult2 = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.INVALID_DISCHARGE_STATUS, this.descriptionAccess);
                ProcessingData data = processingData.toBuilder().withInitialResult(grouperResult2).withFinalResult(grouperResult2).build();
                context = context.toBuilder().withProcessingData(data).build();
                return new Link.LinkResult(context, false);
            }
            if (!dxCode.hasAttribute(MCC_ALIVE) || processingData.getDischargeStatus() != MsdrgDischargeStatus.DIED) continue;
            dxCode.setDeathExclusion(true);
        }
        logger.debug("Execute premdc grouping");
        RuntimeOptions runtimeOptions = context.getRuntime();
        MsdrgMaskBuildingConditions condition = context.getGroupingType().orElseThrow(() -> new FoundationRuntimeException("Unable to determine grouping type. Cannot proceed."));
        MsdrgFormulaEvaluation.EvalContainer evalContainer = this.predMdcGrouping(processingData, context.getSupplierMap(), condition, runtimeOptions);
        if (evalContainer == null) {
            throw new FoundationException("Formula evaluation failed.");
        }
        MsdrgMatchedDrgFormula matchedDrgFormula = evalContainer.getMatchedDrgFormula();
        MsdrgSeverity severity = evalContainer.getSeverity();
        ProcessingData.ProcessingDataBuilder processingDataBuilder = processingData.toBuilder();
        if (matchedDrgFormula.getFormula() != null && matchedDrgFormula.getFormula().contains(GRC_7)) {
            grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.INVALID_PDX, this.descriptionAccess);
            processingDataBuilder.withInitialResult(grouperResult).withFinalResult(grouperResult);
            stopGrouping = true;
        }
        if (matchedDrgFormula.getFormula() != null && matchedDrgFormula.getFormula().contains(GRC_1)) {
            grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.DX_CANNOT_BE_PDX, this.descriptionAccess);
            processingDataBuilder.withInitialResult(grouperResult).withFinalResult(grouperResult);
            stopGrouping = true;
        }
        if (matchedDrgFormula.getFormula() != null && matchedDrgFormula.getFormula().contains(GRC_4)) {
            grouperResult = MsdrgUtility.setUngroupable(MsdrgGrouperReturnCode.INVALID_SEX, this.descriptionAccess);
            processingDataBuilder.withInitialResult(grouperResult).withFinalResult(grouperResult);
            stopGrouping = true;
        }
        ProcessingContext.ProcessingContextBuilder contextBuilder = context.toBuilder();
        if (condition == MsdrgMaskBuildingConditions.INITIAL) {
            contextBuilder.withInitialMatchedFormula(matchedDrgFormula);
            contextBuilder.withInitialMdc(new LinkedList<Integer>(Collections.singleton(0)));
            processingData = processingDataBuilder.withInitialSeverity(severity).build();
            if (!matchedDrgFormula.isEmpty() && runtimeOptions.getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE) {
                MsdrgInitialMarkingLogic initialMarkingLogic = new MsdrgInitialMarkingLogic();
                processingData = initialMarkingLogic.initialMarking(matchedDrgFormula, processingData, 0);
            }
        } else if (condition == MsdrgMaskBuildingConditions.FINAL) {
            contextBuilder.withFinalMatchedFormula(matchedDrgFormula);
            contextBuilder.withFinalMdc(new LinkedList<Integer>(Collections.singletonList(0)));
            processingData = processingDataBuilder.withFinalSeverity(severity).build();
            if (!matchedDrgFormula.isEmpty() && runtimeOptions.getComputeAffectDrg() == MsdrgAffectDrgOptionFlag.COMPUTE) {
                MsdrgFinalMarkingLogic finalMarkingLogic = new MsdrgFinalMarkingLogic();
                processingData = finalMarkingLogic.finalMarking(matchedDrgFormula, processingData, 0);
            }
        }
        contextBuilder.withProcessingData(processingData);
        return new Link.LinkResult(contextBuilder.build(), !stopGrouping);
    }

    private MsdrgFormulaEvaluation.EvalContainer predMdcGrouping(ProcessingData processingData, Map<String, NodeSupplier<DrgLexerToken, Attribute>> supplierMap, MsdrgMaskBuildingConditions condition, RuntimeOptions runtimeOptions) {
        int mdc = 0;
        logger.debug("Try grouping with mdc: {}", (Object)mdc);
        MsdrgMaskBuilder maskBuilder = new MsdrgMaskBuilder();
        MsdrgMaskAttributes mask = maskBuilder.buildMask(processingData);
        MsdrgFormulaEvaluation formulaEvaluation = new MsdrgFormulaEvaluation(this.formulaAccess);
        formulaEvaluation.setSuppliers(supplierMap);
        return formulaEvaluation.evaluateFormulas(processingData.getSdxCodes(), condition, mdc, mask, runtimeOptions.getComputeAffectDrg(), runtimeOptions.getPoaReportingExempt());
    }
}

