/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic.finalprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.enumeration.MsdrgSeverity;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v391.ProcessingData;
import gov.agency.msdrg.v391.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v391.chain.Link;
import gov.agency.msdrg.v391.chain.ProcessingContext;
import gov.agency.msdrg.v391.logic.MsdrgGrouperResultReport;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Function;

public class MsdrgDrgResultsNew
implements Link {
    private final DescriptionDao descriptionDao;
    private final Function<ProcessingContext, Optional<MsdrgMatchedDrgFormula>> formulaFunction;
    private final Function<ProcessingData, MsdrgSeverity> severityFunction;
    private final Function<ProcessingContext, LinkedList<Integer>> mdcsFunction;
    private final Function<MsdrgGrouperResult, ProcessingData.ProcessingDataBuilder> processingDataConsumer;

    public MsdrgDrgResultsNew(DescriptionDao descriptionDao, Function<ProcessingContext, Optional<MsdrgMatchedDrgFormula>> formulaFunction, Function<ProcessingData, MsdrgSeverity> severityFunction, Function<ProcessingContext, LinkedList<Integer>> mdcsFunction, Function<MsdrgGrouperResult, ProcessingData.ProcessingDataBuilder> processingDataConsumer) {
        this.descriptionDao = descriptionDao;
        this.formulaFunction = formulaFunction;
        this.severityFunction = severityFunction;
        this.mdcsFunction = mdcsFunction;
        this.processingDataConsumer = processingDataConsumer;
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        MsdrgGrouperResult result;
        ProcessingData processingData = context.getProcessingData();
        MsdrgMatchedDrgFormula matchedFormula = this.formulaFunction.apply(context).orElseThrow(() -> new FoundationException("No matched formula"));
        LinkedList<Integer> allMdcStops = this.mdcsFunction.apply(context);
        MsdrgGrouperResultReport report = new MsdrgGrouperResultReport();
        if (matchedFormula.getDrg() == 999) {
            result = report.createGrouperResult(0, matchedFormula, this.severityFunction.apply(processingData), this.descriptionDao);
        } else {
            int mdc = processingData.getPrincipalDx().getMdc();
            if (!allMdcStops.isEmpty() && allMdcStops.getLast() == 29) {
                mdc = allMdcStops.contains(24) ? 24 : (allMdcStops.contains(25) ? 25 : allMdcStops.get(allMdcStops.size() - 2));
            } else if (allMdcStops.getLast() != 0) {
                mdc = allMdcStops.getLast();
            }
            result = report.createGrouperResult(mdc, matchedFormula, this.severityFunction.apply(processingData), this.descriptionDao);
        }
        context = context.toBuilder().withProcessingData(this.processingDataConsumer.apply(result).build()).build();
        return new Link.LinkResult(context, true);
    }
}

