/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic.finalprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v391.ProcessingData;
import gov.agency.msdrg.v391.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v391.chain.Link;
import gov.agency.msdrg.v391.chain.ProcessingContext;
import gov.agency.msdrg.v391.logic.MsdrgGrouperResultReport;
import java.util.LinkedList;

public class MsdrgFinalDrgResults
implements Link {
    private final DescriptionDao descriptionDao;

    public MsdrgFinalDrgResults(DescriptionDao descriptionDao) {
        this.descriptionDao = descriptionDao;
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        MsdrgGrouperResult result;
        ProcessingData processingData = context.getProcessingData();
        MsdrgMatchedDrgFormula matchedFormula = context.getFinalMatchedFormula().orElseThrow(() -> new FoundationException("No matched formula"));
        LinkedList<Integer> allMdcStops = context.getFinalMdc();
        MsdrgGrouperResultReport report = new MsdrgGrouperResultReport();
        if (matchedFormula.getDrg() == 999) {
            result = report.createGrouperResult(0, matchedFormula, processingData.getFinalSeverity(), this.descriptionDao);
        } else {
            int mdc = processingData.getPrincipalDx().getMdc();
            if (allMdcStops.getLast() == 29) {
                mdc = allMdcStops.contains(24) ? 24 : (allMdcStops.contains(25) ? 25 : allMdcStops.get(allMdcStops.size() - 2));
            } else if (allMdcStops.getLast() != 0) {
                mdc = allMdcStops.getLast();
            }
            result = report.createGrouperResult(mdc, matchedFormula, processingData.getFinalSeverity(), this.descriptionDao);
        }
        context = context.toBuilder().withProcessingData(processingData.toBuilder().withFinalResult(result).build()).build();
        return new Link.LinkResult(context, true);
    }
}

