/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic.initialprocess;

import gov.agency.msdrg.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.model.transfer.MsdrgGrouperResult;
import gov.agency.msdrg.v391.ProcessingData;
import gov.agency.msdrg.v391.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v391.chain.Link;
import gov.agency.msdrg.v391.chain.ProcessingContext;
import gov.agency.msdrg.v391.logic.MsdrgGrouperResultReport;
import java.util.LinkedList;

public class MsdrgInitialDrgResults
implements Link {
    private final DescriptionDao descriptionDao;

    public MsdrgInitialDrgResults(DescriptionDao descriptionDao) {
        this.descriptionDao = descriptionDao;
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) {
        MsdrgGrouperResult result;
        ProcessingData processingData = context.getProcessingData();
        MsdrgMatchedDrgFormula matchedFormula = context.getInitialMatchedFormula().orElse(new MsdrgMatchedDrgFormula());
        LinkedList<Integer> allMdcStops = context.getInitialMdc();
        MsdrgGrouperResultReport report = new MsdrgGrouperResultReport();
        if (matchedFormula.getDrg() == 999) {
            result = report.createGrouperResult(0, matchedFormula, processingData.getInitialSeverity(), this.descriptionDao);
        } else {
            int mdc = processingData.getPrincipalDx().getMdc();
            if (allMdcStops.getLast() == 29) {
                mdc = allMdcStops.contains(24) ? 24 : (allMdcStops.contains(25) ? 25 : allMdcStops.get(allMdcStops.size() - 2));
            } else if (allMdcStops.getLast() != 0) {
                mdc = allMdcStops.getLast();
            }
            result = report.createGrouperResult(mdc, matchedFormula, processingData.getInitialSeverity(), this.descriptionDao);
        }
        return new Link.LinkResult(context.toBuilder().withProcessingData(processingData.toBuilder().withInitialResult(result).build()).build(), true);
    }
}

