/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v391.logic.preprocess;

import com.mmm.his.cer.utility.farser.ast.node.type.NodeSupplier;
import com.mmm.his.cer.utility.farser.lexer.drg.DrgLexerToken;
import gov.agency.msdrg.model.Attribute;
import gov.agency.msdrg.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.model.RuntimeOptions;
import gov.agency.msdrg.model.enumeration.MarkingLogicTieBreaker;
import gov.agency.msdrg.model.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.model.enumeration.MsdrgSourceLogicLists;
import gov.agency.msdrg.v391.ProcessingData;
import gov.agency.msdrg.v391.access.dao.structure.DiagnosisDao;
import gov.agency.msdrg.v391.chain.Link;
import gov.agency.msdrg.v391.chain.ProcessingContext;
import gov.agency.msdrg.v391.logic.DiagnosisAttributeProcessor;
import gov.agency.msdrg.v391.logic.ast.SigTraumaAstNode;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdxAttributeProcessor
extends DiagnosisAttributeProcessor
implements Link {
    private static final Logger logger = LoggerFactory.getLogger(SdxAttributeProcessor.class);
    private static final String HAC_6_SHOW = "hac06_show";

    public SdxAttributeProcessor(DiagnosisDao diagnosisAccess) {
        super(diagnosisAccess);
    }

    @Override
    public Link.LinkResult execute(ProcessingContext context) {
        logger.debug("Begin processing of attributes");
        RuntimeOptions runtimeOption = context.getRuntime();
        ProcessingData processingData = context.getProcessingData();
        ArrayList<MsdrgDiagnosisCode> sdxCodes = new ArrayList<MsdrgDiagnosisCode>(processingData.getSdxCodes());
        for (MsdrgDiagnosisCode dxCode : sdxCodes) {
            dxCode.setValidCode(this.diagnosisAccess.isCodeValid(dxCode.getValue()));
        }
        for (MsdrgDiagnosisCode dxCode : sdxCodes) {
            try {
                dxCode.setSeverity(this.getDiagnosisSeverity(dxCode));
            }
            catch (IOException | SQLException exception) {
                exception.printStackTrace();
            }
            Set<Attribute> attributes = this.getSdxAttributes(dxCode);
            dxCode.setAttributes(attributes);
            Set<Attribute> dxCatAttributes = this.getSdxDxCatAttributes(dxCode);
            dxCode.setDxCatAttributes(dxCatAttributes);
            Set<Attribute> dxHacAttributes = this.getSdxHacAttributes(dxCode);
            dxCode.setHacAttributes(dxHacAttributes);
            if (!dxHacAttributes.isEmpty()) {
                for (Attribute attr : dxHacAttributes) {
                    if (!attr.getListName().startsWith("HAC")) continue;
                    dxCode.setHacs(this.getDiagnosisHac(dxCode));
                }
            }
            if (dxHacAttributes.contains(new Attribute(MsdrgAttributePrefix.SDX, HAC_6_SHOW))) {
                dxCode.setOnShowList(true);
            }
            Optional<Integer> maybeClinSig = this.diagnosisAccess.getClinicalSignificanceOfCode(dxCode.getValue());
            maybeClinSig.ifPresent(dxCode::setClinicalSignificanceRank);
        }
        if (runtimeOption.getMarkingLogicTieBreaker() == MarkingLogicTieBreaker.CLINICAL_SIGNIFICANCE) {
            sdxCodes.sort((o1, o2) -> {
                if (!o1.isValidCode()) {
                    return 1;
                }
                if (!o2.isValidCode()) {
                    return -1;
                }
                return o1.getClinicalSignificanceRank().compareTo(o2.getClinicalSignificanceRank());
            });
        }
        Map<String, NodeSupplier<DrgLexerToken, Attribute>> suppliers = context.getSupplierMap();
        SigTraumaAstNode.SigTraumaNodeSupplier nodeSupplier = (SigTraumaAstNode.SigTraumaNodeSupplier)suppliers.get(MsdrgSourceLogicLists.MULTST.getValue());
        nodeSupplier.setOrderedCodes(processingData.getPrincipalDx(), sdxCodes);
        context = context.toBuilder().withProcessingData(processingData.toBuilder().withSdxCodes(sdxCodes).build()).build();
        return new Link.LinkResult(context, true);
    }
}

