/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400;

import com.mmm.his.cer.foundation.Processable;
import com.mmm.his.cer.foundation.exception.FoundationException;
import com.mmm.his.cer.foundation.model.GfcPoa;
import gov.agency.msdrg.model.v2.MsdrgGrouperFlags;
import gov.agency.msdrg.model.v2.MsdrgOption;
import gov.agency.msdrg.model.v2.MsdrgRuntimeOption;
import gov.agency.msdrg.model.v2.RuntimeOptions;
import gov.agency.msdrg.model.v2.enumeration.MarkingLogicTieBreaker;
import gov.agency.msdrg.model.v2.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSex;
import gov.agency.msdrg.model.v2.transfer.MsdrgClaim;
import gov.agency.msdrg.model.v2.transfer.input.MsdrgInputData;
import gov.agency.msdrg.model.v2.transfer.input.MsdrgInputDxCode;
import gov.agency.msdrg.model.v2.transfer.input.MsdrgInputPrCode;
import gov.agency.msdrg.model.v2.transfer.output.MsdrgOutput;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.TraceUtility;
import gov.agency.msdrg.v400.access.blob.DataBlob;
import gov.agency.msdrg.v400.access.dao.FormulaAccess;
import gov.agency.msdrg.v400.access.pojo.MsdrgDrgFormula;
import gov.agency.msdrg.v400.chain.GrouperChain;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.FormulaEvaluator;
import gov.agency.msdrg.v400.logic.MsdrgCodeFlagsProcessor;
import gov.agency.msdrg.v400.logic.MsdrgGrouperFlagsResult;
import gov.agency.msdrg.v400.logic.RuntimeDataValidation;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.v400.model.MsdrgProcedureCode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgComponent
implements Processable<MsdrgClaim, MsdrgOption, MsdrgRuntimeOption> {
    public static final String NULL_CODE_VALUE = String.valueOf(null);
    public static final GfcPoa NULL_POA = GfcPoa.BLANK;
    private static final Logger logger = LoggerFactory.getLogger(MsdrgComponent.class);
    private final TraceUtility traceUtility;
    private RuntimeOptions options;
    private Link grouperChain;

    public MsdrgComponent(MsdrgRuntimeOption options) {
        logger.debug("Initializing component constructor");
        this.options = (RuntimeOptions)options.get((Object)MsdrgOption.RUNTIME_OPTION_FLAGS);
        Consumer consumer = (Consumer)options.get((Object)MsdrgOption.TRACE);
        this.traceUtility = new TraceUtility(consumer);
        this.initialize();
    }

    protected void initialize() {
        this.grouperChain = GrouperChain.createChain(DataBlob.getInstance());
        FormulaAccess formulaDao = new FormulaAccess(DataBlob.getInstance());
        for (int mdc = 0; mdc < 30; ++mdc) {
            List<MsdrgDrgFormula> allFormulaRowsByMdc = formulaDao.getAllFormulaRowsByMdc(mdc);
            if (allFormulaRowsByMdc == null) continue;
            for (MsdrgDrgFormula msdrgDrgFormula : allFormulaRowsByMdc) {
                FormulaEvaluator.lexFormula(msdrgDrgFormula.getFormula());
            }
        }
    }

    @Override
    public void process(MsdrgClaim claim) throws FoundationException {
        logger.debug("Begin processing claim");
        RuntimeOptions runtime = RuntimeDataValidation.execute(this.options);
        ProcessingData processingData = this.createProcessingData(claim);
        ArrayList<MsdrgProcedureCode> originalProcedureOrder = new ArrayList<MsdrgProcedureCode>(processingData.getProcedureCodes());
        ArrayList<MsdrgDiagnosisCode> originalDiagnosisOrder = new ArrayList<MsdrgDiagnosisCode>(processingData.getSdxCodes());
        if (runtime.getMarkingLogicTieBreaker() == MarkingLogicTieBreaker.CLINICAL_SIGNIFICANCE) {
            ArrayList<MsdrgProcedureCode> procCodes = new ArrayList<MsdrgProcedureCode>(processingData.getProcedureCodes());
            procCodes.sort(Comparator.comparing(MsdrgCode::getValue));
            processingData = processingData.toBuilder().withProcedures(procCodes).build();
        }
        ProcessingContext context = ProcessingContext.builder().withProcessingData(processingData).withRuntime(runtime).withTrace(this.traceUtility).build();
        this.traceUtility.traceClaim(claim);
        Link.LinkResult linkResult = this.grouperChain.execute(context);
        context = linkResult.getContext();
        ProcessingData processedData = context.getProcessingData();
        if (processedData.getSdxCodes() != null) {
            processedData = processedData.toBuilder().withSdxCodes(originalDiagnosisOrder).build();
        }
        if (processedData.getProcedureCodes() != null) {
            processedData = processedData.toBuilder().withProcedures(originalProcedureOrder).build();
        }
        MsdrgOutput output = this.createOutput(processedData, context);
        this.traceUtility.traceAffectMarking(context);
        claim.setOutput(output);
    }

    private MsdrgOutput createOutput(ProcessingData processedData, ProcessingContext context) {
        RuntimeOptions runtimeOptions = context.getRuntime();
        GroupingContext initialGroupingContext = context.getInitialGroupingContext();
        GroupingContext finalGroupingContext = context.getFinalGroupingContext();
        MsdrgGrouperFlags grouperFlags = MsdrgGrouperFlagsResult.createGrouperFlags(processedData, runtimeOptions.getPoaReportingExempt(), runtimeOptions.getComputeAffectDrg(), initialGroupingContext, finalGroupingContext);
        MsdrgCodeFlagsProcessor.TempFlagsContainer tempFlagsContainer = MsdrgCodeFlagsProcessor.processCodeFlags(processedData, context);
        return MsdrgOutput.builder().withProcOutput(tempFlagsContainer.getProcFlagMap()).withSdxOutput(tempFlagsContainer.getDxFlagMap()).withFinalGrouperResult(processedData.getFinalResult()).withInitialGrouperResult(processedData.getInitialResult()).withPdxOutput(tempFlagsContainer.getPdxFlagMap()).withGrouperFlags(grouperFlags).build();
    }

    private ProcessingData createProcessingData(MsdrgClaim claim) {
        MsdrgInputData input = claim.getInput();
        MsdrgInputDxCode pdx = input.getPrincipalDiagnosisCode().orElse(new MsdrgInputDxCode(NULL_CODE_VALUE, NULL_POA));
        MsdrgInputDxCode admit = input.getAdmissionDiagnosisCode().orElse(new MsdrgInputDxCode(NULL_CODE_VALUE, NULL_POA));
        ArrayList<MsdrgDiagnosisCode> sdxCodes = new ArrayList<MsdrgDiagnosisCode>();
        for (MsdrgInputDxCode secondaryDiagnosisCode : input.getSecondaryDiagnosisCodes()) {
            if (secondaryDiagnosisCode == null) {
                sdxCodes.add(new MsdrgDiagnosisCode(new MsdrgInputDxCode(NULL_CODE_VALUE, NULL_POA)));
                continue;
            }
            sdxCodes.add(new MsdrgDiagnosisCode(secondaryDiagnosisCode));
        }
        ProcessingData.ProcessingDataBuilder processingDataBuilder = ProcessingData.builder().withAdmitDx(new MsdrgDiagnosisCode(admit)).withPdx(new MsdrgDiagnosisCode(pdx)).withSdxCodes(sdxCodes).withDischargeStatus(input.getDischargeStatus().orElse(MsdrgDischargeStatus.NONE)).withSex(input.getSex().orElse(MsdrgSex.UNKNOWN));
        if (!input.getProcedureCodes().isEmpty()) {
            ArrayList<MsdrgProcedureCode> procedureCodes = new ArrayList<MsdrgProcedureCode>();
            for (MsdrgInputPrCode procedureCode : input.getProcedureCodes()) {
                if (procedureCode == null) {
                    procedureCodes.add(new MsdrgProcedureCode(new MsdrgInputPrCode(NULL_CODE_VALUE)));
                    continue;
                }
                procedureCodes.add(new MsdrgProcedureCode(procedureCode));
            }
            MsdrgProcedureCode code = (MsdrgProcedureCode)procedureCodes.get(0);
            if (code != null) {
                code.mark(MsdrgCode.CodeFlag.FIRST_POSITION);
            }
            processingDataBuilder.withPrincipalProcedure(code).withProcedures(procedureCodes);
        }
        return processingDataBuilder.build();
    }

    @Override
    public void reconfigure(MsdrgRuntimeOption option) {
        this.options = (RuntimeOptions)option.get((Object)MsdrgOption.RUNTIME_OPTION_FLAGS);
    }

    public RuntimeOptions getOptions() {
        return this.options;
    }

    @Override
    public void close() {
    }
}

