/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.access.dao;

import gov.agency.msdrg.v400.access.blob.DataAccess;
import gov.agency.msdrg.v400.access.dao.CodeAccess;
import gov.agency.msdrg.v400.access.dao.structure.DiagnosisDao;
import gov.agency.msdrg.v400.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.v400.model.Attribute;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class DiagnosisAccess
extends CodeAccess
implements DiagnosisDao {
    public DiagnosisAccess(DataAccess dataAccess) {
        super(dataAccess);
    }

    @Override
    public Optional<Integer> getMdcOfCode(String code) {
        return this.dataAccess.getCodeMdc(code);
    }

    @Override
    public Optional<Integer> getMdcOfGenderCode(String code, int gender) {
        return Optional.ofNullable(this.dataAccess.getCodeGenderMdcs(code).get(gender));
    }

    @Override
    public Optional<String> getSeverityOfCode(String code) {
        return this.dataAccess.getCodeSeverity(code);
    }

    @Override
    public Set<Attribute> getDxCatListForPdx(String code) {
        List<String> attrStrings = this.dataAccess.getDxCatAttributes(code);
        return this.createAttributes(attrStrings, MsdrgAttributePrefix.PDX);
    }

    @Override
    public Set<Attribute> getDxCatListForSdx(String code) {
        List<String> attrStrings = this.dataAccess.getDxCatAttributes(code);
        return this.createAttributes(attrStrings, MsdrgAttributePrefix.SDX);
    }

    @Override
    public Set<Attribute> getDxHacAttributesForPdx(String code) {
        List<String> attrStrings = this.dataAccess.getDxHacAttributes(code);
        return this.createAttributes(attrStrings, MsdrgAttributePrefix.PDX);
    }

    @Override
    public Set<Attribute> getDxHacAttributesForSdx(String code) {
        List<String> attrStrings = this.dataAccess.getDxHacAttributes(code);
        return this.createAttributes(attrStrings, MsdrgAttributePrefix.SDX);
    }

    @Override
    public Set<Attribute> getAttributesForPrincipalDiagnosis(String code) {
        return this.dataAccess.getDxAttributes(code).stream().filter(value -> !value.isEmpty()).map(value -> new Attribute(MsdrgAttributePrefix.PDX, false, (String)value)).collect(Collectors.toSet());
    }

    @Override
    public Set<Attribute> getAttributesForSecondaryDiagnosis(String code) {
        return this.dataAccess.getDxAttributes(code).stream().filter(value -> !value.isEmpty()).map(value -> new Attribute(MsdrgAttributePrefix.SDX, false, (String)value)).collect(Collectors.toSet());
    }

    @Override
    public Optional<Integer> getClinicalSignificanceOfCode(String code) {
        return this.dataAccess.getClinicalSignificance(code);
    }

    private Set<Attribute> createAttributes(List<String> strings, MsdrgAttributePrefix prefix) {
        return strings.stream().filter(attr -> !attr.isEmpty()).map(attr -> new Attribute(prefix, false, (String)attr)).collect(Collectors.toSet());
    }
}

