/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.access.pojo;

import gov.agency.msdrg.v400.access.blob.dto.ClusterParts;
import gov.agency.msdrg.v400.model.ClusterChoices;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MsdrgClusterDefinition {
    private ClusterChoices choices;
    private String clusterCode;
    private List<String> procedureCodes;
    private Set<Integer> mdcRestrictions;

    public MsdrgClusterDefinition(String clusterCode, ClusterParts clusterParts) {
        this.clusterCode = clusterCode;
        this.mdcRestrictions = clusterParts.getSuppressionMdcs();
        this.procedureCodes = new ArrayList<String>(clusterParts.getCodes());
        this.choices = clusterParts.getChoices();
    }

    public MsdrgClusterDefinition(String clusterCode, List<String> procedureCodes, Set<Integer> mdcRestrictions) {
        this.clusterCode = clusterCode;
        this.procedureCodes = procedureCodes;
        this.mdcRestrictions = mdcRestrictions;
    }

    public String getClusterCode() {
        return this.clusterCode;
    }

    public void setClusterCode(String clusterCode) {
        this.clusterCode = clusterCode;
    }

    public List<String> getProcedureCodes() {
        return this.procedureCodes;
    }

    public void setProcedureCodes(List<String> procedureCodes) {
        this.procedureCodes = procedureCodes;
    }

    public Set<Integer> getMdcRestrictions() {
        return this.mdcRestrictions;
    }

    public void setMdcRestrictions(Set<Integer> mdcRestrictions) {
        this.mdcRestrictions = mdcRestrictions;
    }

    public ClusterChoices getChoices() {
        return this.choices;
    }

    public void setChoices(ClusterChoices choices) {
        this.choices = choices;
    }

    public int getChoiceCount() {
        return this.choices.getChoiceCount();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MsdrgClusterDefinition)) {
            return false;
        }
        MsdrgClusterDefinition that = (MsdrgClusterDefinition)obj;
        return this.getClusterCode().equals(that.getClusterCode()) && this.getProcedureCodes().equals(that.getProcedureCodes()) && this.getMdcRestrictions().equals(that.getMdcRestrictions());
    }

    public int hashCode() {
        return Objects.hash(this.getClusterCode(), this.getProcedureCodes(), this.getMdcRestrictions());
    }

    public String toString() {
        return "MsdrgClusterDefinition{clusterCode='" + this.clusterCode + '\'' + ", procedureCodes=" + this.procedureCodes + ", mdcRestrictions=" + this.mdcRestrictions + '}';
    }
}

