/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.chain;

import gov.agency.msdrg.v400.access.blob.DataAccess;
import gov.agency.msdrg.v400.access.dao.ClusterAccess;
import gov.agency.msdrg.v400.access.dao.DescriptionAccess;
import gov.agency.msdrg.v400.access.dao.DiagnosisAccess;
import gov.agency.msdrg.v400.access.dao.ExclusionAccess;
import gov.agency.msdrg.v400.access.dao.FormulaAccess;
import gov.agency.msdrg.v400.access.dao.ProcedureAccess;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.logic.MsdrgHacProcessor;
import gov.agency.msdrg.v400.logic.finalprocess.MsdrgFinalDrgResults;
import gov.agency.msdrg.v400.logic.finalprocess.MsdrgFinalPdxGrouping;
import gov.agency.msdrg.v400.logic.finalprocess.MsdrgFinalPreGrouping;
import gov.agency.msdrg.v400.logic.finalprocess.MsdrgFinalRerouting;
import gov.agency.msdrg.v400.logic.initialprocess.MsdrgInitialDrgResults;
import gov.agency.msdrg.v400.logic.initialprocess.MsdrgInitialPdxGrouping;
import gov.agency.msdrg.v400.logic.initialprocess.MsdrgInitialPreGrouping;
import gov.agency.msdrg.v400.logic.initialprocess.MsdrgInitialRerouting;
import gov.agency.msdrg.v400.logic.marking.FinalDiagnosisMarking;
import gov.agency.msdrg.v400.logic.marking.FinalDxFunctionMarking;
import gov.agency.msdrg.v400.logic.marking.FinalProcedureMarking;
import gov.agency.msdrg.v400.logic.marking.FinalSgFunctionMarking;
import gov.agency.msdrg.v400.logic.marking.InitialDiagnosisMarking;
import gov.agency.msdrg.v400.logic.marking.InitialDxFunctionMarking;
import gov.agency.msdrg.v400.logic.marking.InitialProcedureMarking;
import gov.agency.msdrg.v400.logic.marking.InitialSgFunctionMarking;
import gov.agency.msdrg.v400.logic.preprocess.MsdrgClusters;
import gov.agency.msdrg.v400.logic.preprocess.MsdrgExclusions;
import gov.agency.msdrg.v400.logic.preprocess.PdxAttributeProcessor;
import gov.agency.msdrg.v400.logic.preprocess.ProcedureAttributeProcessor;
import gov.agency.msdrg.v400.logic.preprocess.SdxAttributeProcessor;
import gov.agency.msdrg.v400.logic.preprocess.SupplierSetup;
import java.util.stream.Stream;

public class GrouperChain {
    private GrouperChain() {
    }

    public static Link createChain(DataAccess access) {
        DiagnosisAccess diagnosisDao = new DiagnosisAccess(access);
        ProcedureAccess procedureDao = new ProcedureAccess(access);
        DescriptionAccess descriptionDao = new DescriptionAccess(access);
        ExclusionAccess exclusionDao = new ExclusionAccess(access);
        FormulaAccess formulaDao = new FormulaAccess(access);
        ClusterAccess clusterDao = new ClusterAccess(access);
        Link preprocessingLink = Stream.of(new MsdrgClusters(clusterDao), new ProcedureAttributeProcessor(procedureDao), new SdxAttributeProcessor(diagnosisDao), new MsdrgExclusions(exclusionDao), new PdxAttributeProcessor(diagnosisDao, descriptionDao), new SupplierSetup()).reduce((current, before) -> before.compose((Link)current)).orElse(context -> new Link.LinkResult(context, false));
        Link initialMarking = Stream.of(new InitialDiagnosisMarking(), new InitialProcedureMarking(), new InitialDxFunctionMarking(), new InitialSgFunctionMarking()).reduce((current, before) -> before.compose((Link)current)).orElse(context -> new Link.LinkResult(context, false));
        Link finalMarking = Stream.of(new FinalDiagnosisMarking(), new FinalProcedureMarking(), new FinalDxFunctionMarking(), new FinalSgFunctionMarking()).reduce((current, before) -> before.compose((Link)current)).orElse(context -> new Link.LinkResult(context, false));
        Link initialGroupingLink = Stream.of(new MsdrgInitialPreGrouping(formulaDao, descriptionDao), new MsdrgInitialRerouting(formulaDao, descriptionDao), new MsdrgInitialPdxGrouping(formulaDao, descriptionDao), new MsdrgInitialRerouting(formulaDao, descriptionDao), new MsdrgInitialDrgResults(descriptionDao)).reduce((current, before) -> before.compose((Link)current)).orElse(context -> new Link.LinkResult(context, false));
        Link finalGroupingLink = Stream.of(new MsdrgFinalPreGrouping(formulaDao, descriptionDao), new MsdrgFinalRerouting(formulaDao, descriptionDao), new MsdrgFinalPdxGrouping(formulaDao, descriptionDao), new MsdrgFinalRerouting(formulaDao, descriptionDao), new MsdrgFinalDrgResults(descriptionDao)).reduce((current, before) -> before.compose((Link)current)).orElse(context -> new Link.LinkResult(context, false));
        return Stream.of(preprocessingLink, initialGroupingLink, initialMarking, new MsdrgHacProcessor(descriptionDao, formulaDao), finalGroupingLink, finalMarking).reduce((current, before) -> before.compose((Link)current)).orElse(context -> new Link.LinkResult(context, false));
    }
}

