/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.chain;

import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgMatchedDrgFormula;
import java.util.Set;

public final class GroupingContext {
    private final LogicState logicState;
    private final MsdrgMatchedDrgFormula preMatch;
    private final MsdrgMatchedDrgFormula rerouteMatch;
    private final MsdrgMatchedDrgFormula pdxMatch;

    private GroupingContext(MsdrgMatchedDrgFormula preMatch, MsdrgMatchedDrgFormula rerouteMatch, MsdrgMatchedDrgFormula pdxMatch, LogicState logicState) {
        this.logicState = logicState;
        this.preMatch = preMatch == null ? new MsdrgMatchedDrgFormula() : preMatch;
        this.rerouteMatch = rerouteMatch == null ? new MsdrgMatchedDrgFormula() : rerouteMatch;
        this.pdxMatch = pdxMatch == null ? new MsdrgMatchedDrgFormula() : pdxMatch;
    }

    public MsdrgMatchedDrgFormula getPreMatch() {
        return this.preMatch;
    }

    public boolean needReroute() {
        boolean result = !this.rerouteMatch.isEmpty() ? false : (this.logicState == LogicState.PDX ? this.preMatch.getReRouteMdcId() != 0 : this.pdxMatch.getReRouteMdcId() != 0);
        return result;
    }

    public boolean hasMatch() {
        return !this.preMatch.isEmpty() || !this.rerouteMatch.isEmpty() || !this.pdxMatch.isEmpty();
    }

    public MsdrgMatchedDrgFormula getPreviousStateMatch() {
        if (this.logicState == LogicState.PDX) {
            return this.preMatch;
        }
        return this.pdxMatch;
    }

    public boolean isEmpty() {
        return this.preMatch.isEmpty() && this.pdxMatch.isEmpty() && this.rerouteMatch.isEmpty();
    }

    public boolean differentDrgs(GroupingContext other) {
        MsdrgMatchedDrgFormula thisMatch = this.getMatch();
        MsdrgMatchedDrgFormula otherMatch = other.getMatch();
        if (thisMatch.isEmpty() || otherMatch.isEmpty()) {
            return true;
        }
        return thisMatch.getDrg() != otherMatch.getDrg();
    }

    public int getMatchDrg() {
        return this.getMatch().getDrg();
    }

    public int getMatchRerouteMdc() {
        return this.getMatch().getReRouteMdcId();
    }

    public Set<Attribute> getMatchAttributes() {
        return this.getMatch().getMatchedAttributes();
    }

    public MsdrgMatchedDrgFormula getMatch() {
        MsdrgMatchedDrgFormula result = this.preMatch;
        if (!this.rerouteMatch.isEmpty()) {
            result = this.rerouteMatch;
        } else if (this.logicState == LogicState.DONE) {
            result = this.pdxMatch;
        }
        return result;
    }

    public static GroupingContextBuilder builder() {
        return new GroupingContextBuilder();
    }

    public GroupingContextBuilder toBuilder() {
        return new GroupingContextBuilder(this);
    }

    public static final class GroupingContextBuilder {
        private MsdrgMatchedDrgFormula preMatch;
        private MsdrgMatchedDrgFormula rerouteMatch;
        private MsdrgMatchedDrgFormula pdxMatch;
        private LogicState logicState = LogicState.PRE;

        private GroupingContextBuilder() {
        }

        private GroupingContextBuilder(GroupingContext other) {
            this.preMatch = other.preMatch;
            this.rerouteMatch = other.rerouteMatch;
            this.pdxMatch = other.pdxMatch;
            this.logicState = other.logicState;
        }

        public GroupingContextBuilder withPreMatch(MsdrgMatchedDrgFormula preMatch) {
            this.preMatch = preMatch;
            this.logicState = LogicState.PDX;
            return this;
        }

        public GroupingContextBuilder withRerouteMatch(MsdrgMatchedDrgFormula rerouteMatch) {
            this.rerouteMatch = rerouteMatch;
            return this;
        }

        public GroupingContextBuilder withPdxMatch(MsdrgMatchedDrgFormula pdxMatch) {
            this.pdxMatch = pdxMatch;
            this.logicState = LogicState.DONE;
            return this;
        }

        public GroupingContext build() {
            return new GroupingContext(this.preMatch, this.rerouteMatch, this.pdxMatch, this.logicState);
        }
    }

    private static enum LogicState {
        PRE,
        PDX,
        DONE;

    }
}

