/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.chain;

import gov.agency.msdrg.model.v2.RuntimeOptions;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.TraceUtility;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.logic.ast.AstContext;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.NodeSupplier;
import gov.agency.msdrg.v400.utility.farser.lexer.drg.DrgLexerToken;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ProcessingContext {
    private final Map<String, NodeSupplier<DrgLexerToken, AstContext>> supplierMap;
    private final RuntimeOptions runtime;
    private final TraceUtility traceUtility;
    private final ProcessingData processingData;
    private final GroupingContext initialGroupingContext;
    private final GroupingContext finalGroupingContext;
    private final LinkedList<Integer> initialMdc;
    private final LinkedList<Integer> finalMdc;

    private ProcessingContext(Map<String, NodeSupplier<DrgLexerToken, AstContext>> supplierMap, RuntimeOptions runtime, TraceUtility traceUtility, ProcessingData processingData, GroupingContext initialGroupingContext, GroupingContext finalGroupingContext, List<Integer> initialMdc, List<Integer> finalMdc) {
        this.supplierMap = new HashMap<String, NodeSupplier<DrgLexerToken, AstContext>>(supplierMap);
        this.runtime = runtime;
        this.traceUtility = traceUtility;
        this.processingData = processingData;
        this.initialGroupingContext = initialGroupingContext == null ? GroupingContext.builder().build() : initialGroupingContext;
        this.finalGroupingContext = finalGroupingContext == null ? GroupingContext.builder().build() : finalGroupingContext;
        this.initialMdc = initialMdc == null ? new LinkedList() : new LinkedList<Integer>(initialMdc);
        this.finalMdc = finalMdc == null ? new LinkedList() : new LinkedList<Integer>(finalMdc);
    }

    public static ProcessingContextBuilder builder() {
        return new ProcessingContextBuilder();
    }

    public ProcessingContextBuilder toBuilder() {
        return new ProcessingContextBuilder(this);
    }

    public Map<String, NodeSupplier<DrgLexerToken, AstContext>> getSupplierMap() {
        return Collections.unmodifiableMap(this.supplierMap);
    }

    public RuntimeOptions getRuntime() {
        return this.runtime;
    }

    public TraceUtility getTraceUtility() {
        return this.traceUtility;
    }

    public ProcessingData getProcessingData() {
        return this.processingData;
    }

    public GroupingContext getInitialGroupingContext() {
        return this.initialGroupingContext;
    }

    public GroupingContext getFinalGroupingContext() {
        return this.finalGroupingContext;
    }

    public LinkedList<Integer> getInitialMdc() {
        return new LinkedList<Integer>(this.initialMdc);
    }

    public LinkedList<Integer> getFinalMdc() {
        return new LinkedList<Integer>(this.finalMdc);
    }

    public static final class ProcessingContextBuilder {
        private Map<String, NodeSupplier<DrgLexerToken, AstContext>> supplierMap = new HashMap<String, NodeSupplier<DrgLexerToken, AstContext>>();
        private RuntimeOptions runtime;
        private TraceUtility traceUtility;
        private ProcessingData processingData;
        private GroupingContext initialGroupingContext;
        private GroupingContext finalGroupingContext;
        private List<Integer> initialMdc;
        private List<Integer> finalMdc;

        private ProcessingContextBuilder() {
        }

        private ProcessingContextBuilder(ProcessingContext other) {
            this.supplierMap = other.supplierMap;
            this.runtime = other.runtime;
            this.traceUtility = other.traceUtility;
            this.processingData = other.processingData;
            this.initialGroupingContext = other.initialGroupingContext;
            this.finalGroupingContext = other.finalGroupingContext;
            this.initialMdc = other.initialMdc;
            this.finalMdc = other.finalMdc;
        }

        public ProcessingContextBuilder withSupplierMap(Map<String, NodeSupplier<DrgLexerToken, AstContext>> supplierMap) {
            this.supplierMap = supplierMap;
            return this;
        }

        public ProcessingContextBuilder withRuntime(RuntimeOptions runtime) {
            this.runtime = runtime;
            return this;
        }

        public ProcessingContextBuilder withTrace(TraceUtility trace) {
            this.traceUtility = trace;
            return this;
        }

        public ProcessingContextBuilder withProcessingData(ProcessingData processingData) {
            this.processingData = processingData;
            return this;
        }

        public ProcessingContextBuilder withInitialGroupingContext(GroupingContext initialGroupingContext) {
            this.initialGroupingContext = initialGroupingContext;
            return this;
        }

        public ProcessingContextBuilder withFinalGroupingContext(GroupingContext finalGroupingContext) {
            this.finalGroupingContext = finalGroupingContext;
            return this;
        }

        public ProcessingContextBuilder withInitialMdc(LinkedList<Integer> initialMdc) {
            this.initialMdc = initialMdc;
            return this;
        }

        public ProcessingContextBuilder withFinalMdc(LinkedList<Integer> finalMdc) {
            this.finalMdc = finalMdc;
            return this;
        }

        public ProcessingContext build() {
            return new ProcessingContext(this.supplierMap, this.runtime, this.traceUtility, this.processingData, this.initialGroupingContext, this.finalGroupingContext, this.initialMdc, this.finalMdc);
        }
    }
}

