/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic;

import gov.agency.msdrg.model.v2.enumeration.MsdrgDischargeStatus;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSex;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.v400.enumeration.MsdrgSourceLogicLists;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.v400.model.MsdrgMaskAttributes;
import gov.agency.msdrg.v400.model.MsdrgProcedureCode;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsdrgMaskBuilder {
    private static final Logger logger = LoggerFactory.getLogger(MsdrgMaskBuilder.class);
    private static final Set<Integer> XFRNBA_INT_SET = new HashSet<Integer>(Arrays.asList(2, 5, 66, 82, 85, 94));
    private static final String XFRNBA = "XFRNBA";
    private static final String INCIDENT = "incident";
    private static final Pattern pattern = Pattern.compile("^([VWXYvwxy])");

    public MsdrgMaskAttributes buildMask(ProcessingData processingData) {
        MsdrgSex sex;
        MsdrgDischargeStatus dischargeStatus;
        List<MsdrgDiagnosisCode> sdxCodes = processingData.getSdxCodes();
        MsdrgMaskAttributes mask = new MsdrgMaskAttributes();
        logger.debug("Begin mask building");
        logger.debug("Get sdx attributes for mask");
        for (MsdrgDiagnosisCode msdrgDiagnosisCode : sdxCodes) {
            MsdrgMaskAttributes.updateMask(mask, new HashSet<Attribute>(msdrgDiagnosisCode.getAttributes()));
            MsdrgMaskAttributes.updateMask(mask, new HashSet<Attribute>(msdrgDiagnosisCode.getDxCatAttributes()));
            MsdrgMaskAttributes.updateMask(mask, new HashSet<Attribute>(msdrgDiagnosisCode.getHacAttributes()));
        }
        List<MsdrgProcedureCode> procedureCodes = processingData.getProcedureCodes();
        logger.debug("Get proc attributes for mask");
        for (MsdrgProcedureCode msdrgProcedureCode : procedureCodes) {
            MsdrgMaskAttributes.updateMask(mask, new HashSet<Attribute>(msdrgProcedureCode.getAttributes()));
        }
        List<MsdrgProcedureCode> list = processingData.getClusters();
        logger.debug("Get cluster attributes for mask");
        for (MsdrgProcedureCode code : list) {
            MsdrgMaskAttributes.updateMask(mask, new HashSet<Attribute>(code.getAttributes()));
        }
        logger.debug("Get pdx attributes for mask");
        MsdrgDiagnosisCode msdrgDiagnosisCode = processingData.getPrincipalDx();
        MsdrgMaskAttributes.updateMask(mask, new HashSet<Attribute>(msdrgDiagnosisCode.getAttributes()));
        MsdrgMaskAttributes.updateMask(mask, new HashSet<Attribute>(msdrgDiagnosisCode.getHacAttributes()));
        MsdrgMaskAttributes.updateMask(mask, new HashSet<Attribute>(msdrgDiagnosisCode.getDxCatAttributes()));
        if (!msdrgDiagnosisCode.is(MsdrgCode.CodeFlag.VALID)) {
            mask.addToMask(new Attribute(MsdrgAttributePrefix.PDX, MsdrgSourceLogicLists.INVALID_PDX.getValue()));
        }
        if (pattern.matcher(msdrgDiagnosisCode.getValue()).lookingAt()) {
            mask.addToMask(new Attribute(MsdrgAttributePrefix.PDX, MsdrgSourceLogicLists.PDX_ECODE.getValue()));
        }
        if ((dischargeStatus = processingData.getDischargeStatus()) != MsdrgDischargeStatus.DIED) {
            mask.addToMask(new Attribute("ALIVE"));
        }
        if (dischargeStatus.hasFormulaString()) {
            mask.addToMask(new Attribute(dischargeStatus.getFormulaString()));
        }
        if (XFRNBA_INT_SET.contains(dischargeStatus.intValue())) {
            mask.addToMask(new Attribute(XFRNBA));
        }
        mask.addToMask(new Attribute(MsdrgSourceLogicLists.ANYDX.getValue()));
        if (msdrgDiagnosisCode.hasAttribute(INCIDENT)) {
            boolean isOnIncidentList = true;
            for (MsdrgDiagnosisCode code : sdxCodes) {
                if (!code.is(MsdrgCode.CodeFlag.VALID) || code.hasAttribute(INCIDENT)) continue;
                isOnIncidentList = false;
                break;
            }
            if (isOnIncidentList) {
                mask.addToMask(new Attribute(MsdrgAttributePrefix.ONLY, INCIDENT));
            }
        }
        if ((sex = processingData.getSex()) == MsdrgSex.UNKNOWN && msdrgDiagnosisCode.is(MsdrgCode.CodeFlag.SEX_CONFLICT)) {
            mask.addToMask(new Attribute(MsdrgSourceLogicLists.INVALID_SEX.getValue()));
        }
        logger.debug("Mask building finished");
        return mask;
    }
}

