/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.ast;

import gov.agency.msdrg.v400.logic.ast.AstContext;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.BooleanExpression;
import java.util.List;
import java.util.Optional;

public class MdcFallThruNode
implements BooleanExpression<AstContext> {
    private final int mdcValue;
    private final boolean pdx;

    public MdcFallThruNode(int mdcValue, boolean pdx) {
        this.mdcValue = mdcValue;
        this.pdx = pdx;
    }

    @Override
    public boolean evaluate(AstContext context) {
        List<MsdrgDiagnosisCode> diagnosisCodes = context.getDiagnosisCodes();
        if (diagnosisCodes.isEmpty()) {
            return false;
        }
        if (this.pdx) {
            MsdrgDiagnosisCode pdxCode = diagnosisCodes.get(0);
            return pdxCode.getMdc() == this.mdcValue;
        }
        Optional<MsdrgDiagnosisCode> first = diagnosisCodes.stream().filter(code -> code.getMdc() == this.mdcValue).findFirst();
        if (first.isPresent()) {
            MsdrgDiagnosisCode diagnosisCode = first.get();
            diagnosisCode.mark(MsdrgCode.CodeFlag.AFFECTS_DRG);
            return true;
        }
        return false;
    }
}

