/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.ast;

import gov.agency.msdrg.v400.logic.ast.AstContext;
import gov.agency.msdrg.v400.logic.ast.AttributeEnum;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.BooleanExpression;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class SignificantTrauma
implements BooleanExpression<AstContext> {
    @Override
    public boolean evaluate(AstContext context) {
        List<MsdrgDiagnosisCode> orderedCodes = context.getDiagnosisCodes();
        HashSet<MsdrgDiagnosisCode> codesToMark = new HashSet<MsdrgDiagnosisCode>();
        HashSet<Attribute> bilateralsFound = new HashSet<Attribute>();
        for (MsdrgDiagnosisCode code2 : orderedCodes) {
            if (bilateralsFound.size() == 2) break;
            Optional<Attribute> maybeAttribute = this.checkAttributes(code2, bilateralsFound);
            if (!maybeAttribute.isPresent()) continue;
            codesToMark.add(code2);
            bilateralsFound.add(maybeAttribute.get());
        }
        if (bilateralsFound.size() == 2) {
            context.accumulate(bilateralsFound);
            codesToMark.forEach(code -> code.mark(MsdrgCode.CodeFlag.SIG_TRAUMA));
        }
        return bilateralsFound.size() == 2;
    }

    private Optional<Attribute> checkAttributes(MsdrgDiagnosisCode code, Set<Attribute> foundAttrs) {
        for (SigTrauma value : SigTrauma.values()) {
            Attribute attribute = value.getAttribute();
            if (!code.hasAttribute(attribute.getListName()) || foundAttrs.contains(attribute)) continue;
            return Optional.of(attribute);
        }
        return Optional.empty();
    }

    private static enum SigTrauma implements AttributeEnum
    {
        ST_HEAD(new Attribute("sthead")),
        ST_CHEST(new Attribute("stchest")),
        ST_ABDOM(new Attribute("stabdom")),
        ST_KIDNEY(new Attribute("stkidney")),
        ST_URIN(new Attribute("sturin")),
        ST_PEL(new Attribute("stpel")),
        ST_UPLIMB(new Attribute("stuplimb")),
        ST_LOLIMB(new Attribute("stlolimb"));

        private final Attribute attribute;

        private SigTrauma(Attribute attribute) {
            this.attribute = attribute;
        }

        @Override
        public Attribute getAttribute() {
            return this.attribute;
        }
    }
}

