/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.ast;

import gov.agency.msdrg.v400.enumeration.MsdrgAttributePrefix;
import gov.agency.msdrg.v400.enumeration.MsdrgSourceLogicLists;
import gov.agency.msdrg.v400.logic.ast.AstContext;
import gov.agency.msdrg.v400.logic.ast.AttributeEnum;
import gov.agency.msdrg.v400.logic.ast.BilateralNode;
import gov.agency.msdrg.v400.logic.ast.CountFourNode;
import gov.agency.msdrg.v400.logic.ast.GrcNode;
import gov.agency.msdrg.v400.logic.ast.MdcFallThruNode;
import gov.agency.msdrg.v400.logic.ast.OnlyIncidentNode;
import gov.agency.msdrg.v400.logic.ast.SignificantTrauma;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.NodeSupplier;
import gov.agency.msdrg.v400.utility.farser.lexer.drg.DrgLexerToken;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public enum SupplierFactory {
    SIG_TRAUMA(false, MsdrgSourceLogicLists.MULTST){

        @Override
        public NodeSupplier<DrgLexerToken, AstContext> getSupplier() {
            return token -> new SignificantTrauma();
        }
    }
    ,
    BILATERAL(true, MsdrgSourceLogicLists.BILATERAL){

        @Override
        public NodeSupplier<DrgLexerToken, AstContext> getSupplier() {
            return token -> new BilateralNode();
        }
    }
    ,
    VESSEL(true, MsdrgSourceLogicLists.FOUR_VESSELS){

        @Override
        public NodeSupplier<DrgLexerToken, AstContext> getSupplier() {
            return token -> new CountFourNode(null, Vessel.class, MsdrgCode.CodeFlag.VESSEL_4);
        }
    }
    ,
    DRUG_ELUDING(true, MsdrgSourceLogicLists.FOUR_DRUG_ELUTING_STENTS){

        @Override
        public NodeSupplier<DrgLexerToken, AstContext> getSupplier() {
            return token -> new CountFourNode(new Attribute(MsdrgSourceLogicLists.NORDRUGSTENT.getValue()), Stent.class, MsdrgCode.CodeFlag.STENT_4);
        }
    }
    ,
    NON_DRUG_ELUDING(true, MsdrgSourceLogicLists.FOUR_NON_DRUG_ELUTING_STENTS){

        @Override
        public NodeSupplier<DrgLexerToken, AstContext> getSupplier() {
            return token -> new CountFourNode(new Attribute(MsdrgSourceLogicLists.NORSTENT.getValue()), Stent.class, MsdrgCode.CodeFlag.STENT_4);
        }
    }
    ,
    INVALID_DSTAT(false, MsdrgSourceLogicLists.INVALID_DSTAT){

        @Override
        public NodeSupplier<DrgLexerToken, AstContext> getSupplier() {
            return token -> new GrcNode(MsdrgSourceLogicLists.INVALID_DSTAT, MsdrgAttributePrefix.NONE);
        }
    }
    ,
    INVALID_PDX(false, MsdrgSourceLogicLists.INVALID_PDX){

        @Override
        public NodeSupplier<DrgLexerToken, AstContext> getSupplier() {
            return token -> new GrcNode(MsdrgSourceLogicLists.INVALID_PDX, MsdrgAttributePrefix.PDX);
        }
    }
    ,
    INVALID_SEX(false, MsdrgSourceLogicLists.INVALID_SEX){

        @Override
        public NodeSupplier<DrgLexerToken, AstContext> getSupplier() {
            return token -> new GrcNode(MsdrgSourceLogicLists.INVALID_SEX, MsdrgAttributePrefix.NONE);
        }
    }
    ,
    PDX_ECODE(false, MsdrgSourceLogicLists.PDX_ECODE){

        @Override
        public NodeSupplier<DrgLexerToken, AstContext> getSupplier() {
            return token -> new GrcNode(MsdrgSourceLogicLists.PDX_ECODE, MsdrgAttributePrefix.PDX);
        }
    }
    ,
    INVALID_AGE(false, MsdrgSourceLogicLists.INVALID_AGE){

        @Override
        public NodeSupplier<DrgLexerToken, AstContext> getSupplier() {
            return token -> new GrcNode(MsdrgSourceLogicLists.INVALID_AGE, MsdrgAttributePrefix.NONE);
        }
    }
    ,
    MDC_20_FALL_THRU(false, MsdrgSourceLogicLists.MDC_20_FALL_THRU){

        @Override
        public NodeSupplier<DrgLexerToken, AstContext> getSupplier() {
            return token -> new MdcFallThruNode(20, true);
        }
    }
    ,
    ONLY_INCIDENT(false, MsdrgSourceLogicLists.incident){

        @Override
        public NodeSupplier<DrgLexerToken, AstContext> getSupplier() {
            return token -> new OnlyIncidentNode(new Attribute(MsdrgAttributePrefix.ONLY, false, MsdrgSourceLogicLists.incident.name()));
        }
    };

    private static final Map<String, NodeSupplier<DrgLexerToken, AstContext>> procedureSuppliers;
    private static final Map<String, NodeSupplier<DrgLexerToken, AstContext>> diagnosisSuppliers;
    private final boolean proc;
    private final MsdrgSourceLogicLists supplierMapKey;

    public abstract NodeSupplier<DrgLexerToken, AstContext> getSupplier();

    private SupplierFactory(boolean proc, MsdrgSourceLogicLists supplierMapKey) {
        this.proc = proc;
        this.supplierMapKey = supplierMapKey;
    }

    public static Map<String, NodeSupplier<DrgLexerToken, AstContext>> getProcedureSuppliers() {
        return procedureSuppliers;
    }

    public static Map<String, NodeSupplier<DrgLexerToken, AstContext>> getDiagnosisSuppliers() {
        return diagnosisSuppliers;
    }

    private static Map<String, NodeSupplier<DrgLexerToken, AstContext>> filterSuppliers(Predicate<? super SupplierFactory> predicate) {
        return Arrays.stream(SupplierFactory.values()).filter(predicate).collect(Collectors.toMap(value -> value.supplierMapKey.name(), SupplierFactory::getSupplier, (a, b) -> b));
    }

    static {
        procedureSuppliers = SupplierFactory.filterSuppliers(value -> value.proc);
        diagnosisSuppliers = SupplierFactory.filterSuppliers(value -> !value.proc);
    }

    private static enum Stent implements AttributeEnum
    {
        STENT1(new Attribute("stent1"), 1),
        STENT2(new Attribute("stent2"), 2),
        STENT3(new Attribute("stent3"), 3),
        STENT4(new Attribute("stent4"), 4);

        private final Attribute attribute;
        private final int stentCount;

        private Stent(Attribute attribute, int stentCount) {
            this.attribute = attribute;
            this.stentCount = stentCount;
        }

        @Override
        public Attribute getAttribute() {
            return this.attribute;
        }

        @Override
        public int getCount() {
            return this.stentCount;
        }
    }

    private static enum Vessel implements AttributeEnum
    {
        VESSEL1(new Attribute("vessel1"), 1),
        VESSEL2(new Attribute("vessel2"), 2),
        VESSEL3(new Attribute("vessel3"), 3),
        VESSEL4(new Attribute("vessel4"), 4);

        private final Attribute attribute;
        private final int stentCount;

        private Vessel(Attribute attribute, int stentCount) {
            this.attribute = attribute;
            this.stentCount = stentCount;
        }

        @Override
        public Attribute getAttribute() {
            return this.attribute;
        }

        @Override
        public int getCount() {
            return this.stentCount;
        }
    }
}

