/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.commonprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.v2.MsdrgGrouperResult;
import gov.agency.msdrg.model.v2.RuntimeOptions;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGroupingImpact;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v400.access.dao.structure.FormulaDao;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.MsdrgFormulaEvaluation;
import gov.agency.msdrg.v400.logic.MsdrgUtility;
import gov.agency.msdrg.v400.logic.ast.AstContext;
import gov.agency.msdrg.v400.logic.commonprocess.GroupingExecutor;
import gov.agency.msdrg.v400.model.MsdrgMatchedDrgFormula;
import gov.agency.msdrg.v400.utility.farser.ast.node.type.NodeSupplier;
import gov.agency.msdrg.v400.utility.farser.lexer.drg.DrgLexerToken;
import java.util.Map;

public abstract class PdxMdcGrouping
implements Link,
GroupingExecutor {
    private final FormulaDao formulaAccess;
    private final DescriptionDao descriptionAccess;

    public PdxMdcGrouping(FormulaDao formulaAccess, DescriptionDao descriptionAccess) {
        this.formulaAccess = formulaAccess;
        this.descriptionAccess = descriptionAccess;
    }

    protected abstract GroupingContext fetchGroupingContext(ProcessingContext var1);

    protected abstract ProcessingContext buildNewProcessingContext(MsdrgMatchedDrgFormula var1, ProcessingContext var2);

    protected abstract ProcessingData addSeverityToProcessingData(ProcessingData var1, MsdrgSeverity var2);

    @Override
    public final Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        MsdrgMatchedDrgFormula matchedDrgFormula;
        Map<String, NodeSupplier<DrgLexerToken, AstContext>> suppliers = context.getSupplierMap();
        ProcessingData processingData = context.getProcessingData();
        GroupingContext groupingContext = this.fetchGroupingContext(context);
        if (groupingContext.hasMatch()) {
            return new Link.LinkResult(context, true);
        }
        RuntimeOptions runtimeOptions = context.getRuntime();
        MsdrgFormulaEvaluation.EvalContainer evalContainer = this.group(processingData, suppliers, runtimeOptions.getPoaReportingExempt(), processingData.getPrincipalDx().getMdc(), this.formulaAccess, context.getTraceUtility());
        if (evalContainer != null) {
            matchedDrgFormula = evalContainer.getMatchedDrgFormula();
            context.getTraceUtility().traceDrgFormula(matchedDrgFormula);
            if (matchedDrgFormula.getGrouperReturnCode() != MsdrgGrouperReturnCode.OK) {
                MsdrgGrouperResult grouperResult = MsdrgUtility.setUngroupable(matchedDrgFormula.getGrouperReturnCode(), this.descriptionAccess);
                processingData.getPrincipalDx().setDrgImpact(MsdrgGroupingImpact.NONE);
                context = context.toBuilder().withProcessingData(processingData.toBuilder().withInitialResult(grouperResult).withFinalResult(grouperResult).build()).build();
                return new Link.LinkResult(context, false);
            }
        } else {
            throw new FoundationException("Could not evaluate formula");
        }
        context = this.buildNewProcessingContext(matchedDrgFormula, context);
        processingData = this.addSeverityToProcessingData(processingData, evalContainer.getSeverity());
        context = context.toBuilder().withProcessingData(processingData).build();
        return new Link.LinkResult(context, true);
    }
}

