/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.commonprocess;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.v2.MsdrgGrouperResult;
import gov.agency.msdrg.model.v2.RuntimeOptions;
import gov.agency.msdrg.model.v2.enumeration.MsdrgGrouperReturnCode;
import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v400.access.dao.structure.FormulaDao;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.MsdrgFormulaEvaluation;
import gov.agency.msdrg.v400.logic.MsdrgUtility;
import gov.agency.msdrg.v400.logic.commonprocess.GroupingExecutor;
import gov.agency.msdrg.v400.model.MsdrgMatchedDrgFormula;

public abstract class PreMdcGrouping
implements Link,
GroupingExecutor {
    private static final int PRE_MDC = 0;
    private final DescriptionDao descriptionAccess;
    private final FormulaDao formulaAccess;

    public PreMdcGrouping(FormulaDao formulaAccess, DescriptionDao descriptionAccess) {
        this.formulaAccess = formulaAccess;
        this.descriptionAccess = descriptionAccess;
    }

    protected abstract ProcessingContext buildNewProcessingContext(MsdrgMatchedDrgFormula var1, ProcessingContext var2);

    protected abstract ProcessingData addSeverityToProcessingData(ProcessingData var1, MsdrgSeverity var2);

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        MsdrgMatchedDrgFormula matchedDrgFormula;
        boolean stopGrouping = false;
        ProcessingData processingData = context.getProcessingData();
        ProcessingData.ProcessingDataBuilder processingDataBuilder = processingData.toBuilder();
        RuntimeOptions runtimeOptions = context.getRuntime();
        MsdrgFormulaEvaluation.EvalContainer evalContainer = this.group(processingData, context.getSupplierMap(), runtimeOptions.getPoaReportingExempt(), 0, this.formulaAccess, context.getTraceUtility());
        if (evalContainer != null) {
            matchedDrgFormula = evalContainer.getMatchedDrgFormula();
            if (matchedDrgFormula.getGrouperReturnCode() != MsdrgGrouperReturnCode.OK) {
                MsdrgGrouperResult grouperResult = MsdrgUtility.setUngroupable(matchedDrgFormula.getGrouperReturnCode(), this.descriptionAccess);
                processingDataBuilder.withInitialResult(grouperResult).withFinalResult(grouperResult);
                stopGrouping = true;
            }
        } else {
            throw new FoundationException("Formula evaluation failed.");
        }
        context = this.buildNewProcessingContext(matchedDrgFormula, context);
        processingData = processingDataBuilder.build();
        processingData = this.addSeverityToProcessingData(processingData, evalContainer.getSeverity());
        context = context.toBuilder().withProcessingData(processingData).build();
        return new Link.LinkResult(context, !stopGrouping);
    }
}

