/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.finalprocess;

import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v400.access.dao.structure.FormulaDao;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.commonprocess.MdcRerouteGrouping;
import gov.agency.msdrg.v400.model.MsdrgMatchedDrgFormula;
import java.util.LinkedList;

public class MsdrgFinalRerouting
extends MdcRerouteGrouping
implements Link {
    public MsdrgFinalRerouting(FormulaDao formulaAccess, DescriptionDao descriptionAccess) {
        super(formulaAccess, descriptionAccess);
    }

    @Override
    protected GroupingContext fetchGroupingContext(ProcessingContext context) {
        return context.getFinalGroupingContext();
    }

    @Override
    protected ProcessingContext buildNewProcessingContext(MsdrgMatchedDrgFormula previousMatch, MsdrgMatchedDrgFormula newMatch, ProcessingContext context) {
        LinkedList<Integer> mdcs = this.fetchMdcs(context);
        mdcs.add(previousMatch.getReRouteMdcId());
        GroupingContext groupingContext = this.fetchGroupingContext(context).toBuilder().withRerouteMatch(newMatch).build();
        ProcessingContext.ProcessingContextBuilder contextBuilder = context.toBuilder().withFinalGroupingContext(groupingContext).withFinalMdc(mdcs);
        return contextBuilder.build();
    }

    @Override
    protected ProcessingData addSeverityToProcessingData(ProcessingData processingData, MsdrgSeverity severity) {
        return processingData.toBuilder().withFinalSeverity(severity).build();
    }

    private LinkedList<Integer> fetchMdcs(ProcessingContext context) {
        return context.getFinalMdc();
    }
}

