/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.initialprocess;

import gov.agency.msdrg.model.v2.enumeration.MsdrgSeverity;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.access.dao.structure.DescriptionDao;
import gov.agency.msdrg.v400.access.dao.structure.FormulaDao;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.commonprocess.PdxMdcGrouping;
import gov.agency.msdrg.v400.model.MsdrgMatchedDrgFormula;
import java.util.LinkedList;

public class MsdrgInitialPdxGrouping
extends PdxMdcGrouping
implements Link {
    public MsdrgInitialPdxGrouping(FormulaDao formulaAccess, DescriptionDao descriptionAccess) {
        super(formulaAccess, descriptionAccess);
    }

    @Override
    protected GroupingContext fetchGroupingContext(ProcessingContext context) {
        return context.getInitialGroupingContext();
    }

    @Override
    protected ProcessingContext buildNewProcessingContext(MsdrgMatchedDrgFormula matchedDrgFormula, ProcessingContext context) {
        int mdc = this.fetchMdc(context);
        LinkedList<Integer> mdcs = this.fetchMdcs(context);
        mdcs.add(mdc);
        GroupingContext.GroupingContextBuilder groupingContext = this.fetchGroupingContext(context).toBuilder();
        groupingContext.withPdxMatch(matchedDrgFormula);
        ProcessingContext.ProcessingContextBuilder contextBuilder = context.toBuilder().withInitialGroupingContext(groupingContext.build()).withInitialMdc(mdcs);
        return contextBuilder.build();
    }

    @Override
    protected ProcessingData addSeverityToProcessingData(ProcessingData processingData, MsdrgSeverity severity) {
        return processingData.toBuilder().withInitialSeverity(severity).build();
    }

    private LinkedList<Integer> fetchMdcs(ProcessingContext context) {
        return context.getInitialMdc();
    }

    private int fetchMdc(ProcessingContext context) {
        return context.getProcessingData().getPrincipalDx().getMdc();
    }
}

