/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.marking;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.marking.Marking;
import gov.agency.msdrg.v400.model.Attribute;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.v400.model.MsdrgMatchedDrgFormula;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public abstract class DiagnosisFunctionMarking
extends Marking
implements Link {
    public static final List<Attribute> SIG_TRAUMAS = Arrays.asList(new Attribute("sthead"), new Attribute("stchest"), new Attribute("stabdom"), new Attribute("stkidney"), new Attribute("sturin"), new Attribute("stpel"), new Attribute("stuplimb"), new Attribute("stlolimb"));

    abstract void setMarked(MsdrgDiagnosisCode var1);

    abstract void setDrgImpact(MsdrgDiagnosisCode var1);

    @Override
    public Link.LinkResult execute(ProcessingContext context) throws FoundationException {
        GroupingContext groupingContext = this.fetchGroupingContext(context);
        ProcessingData processingData = context.getProcessingData();
        MsdrgMatchedDrgFormula preMatch = groupingContext.getPreMatch();
        this.markSigTrauma(preMatch.getMatchedAttributes(), processingData.getSdxCodes(), processingData.getPrincipalDx());
        if (groupingContext.getMatch().getDrg() == 794) {
            this.markNotIncident(processingData.getSdxCodes());
        }
        return new Link.LinkResult(context, true);
    }

    private void markSigTrauma(Set<Attribute> matchedAttributes, List<MsdrgDiagnosisCode> dxCodes, MsdrgDiagnosisCode pdx) {
        int sigTraumaCounter = 0;
        if (pdx.is(MsdrgCode.CodeFlag.SIG_TRAUMA)) {
            this.setMarked(pdx);
            this.setDrgImpact(pdx);
            ++sigTraumaCounter;
        }
        long numSigTrauma = matchedAttributes.stream().filter(SIG_TRAUMAS::contains).count();
        if (numSigTrauma > 0L) {
            for (int i = 0; i < dxCodes.size() && sigTraumaCounter < 2; ++i) {
                MsdrgDiagnosisCode dxCode = dxCodes.get(i);
                if (!dxCode.is(MsdrgCode.CodeFlag.SIG_TRAUMA)) continue;
                this.setMarked(dxCode);
                this.setDrgImpact(dxCode);
                ++sigTraumaCounter;
            }
            SIG_TRAUMAS.forEach(matchedAttributes::remove);
        }
    }

    private void markNotIncident(List<MsdrgDiagnosisCode> dxCodes) {
        for (MsdrgDiagnosisCode dxCode : dxCodes) {
            if (!dxCode.is(MsdrgCode.CodeFlag.NOT_INCIDENT)) continue;
            this.setMarked(dxCode);
            this.setDrgImpact(dxCode);
        }
    }
}

