/*
 * Decompiled with CFR 0.152.
 */
package gov.agency.msdrg.v400.logic.marking;

import com.mmm.his.cer.foundation.exception.FoundationException;
import gov.agency.msdrg.model.v2.MsdrgHac;
import gov.agency.msdrg.model.v2.enumeration.MsdrgHacUsage;
import gov.agency.msdrg.model.v2.enumeration.MsdrgProcedureHacUsage;
import gov.agency.msdrg.v400.ProcessingData;
import gov.agency.msdrg.v400.chain.GroupingContext;
import gov.agency.msdrg.v400.chain.Link;
import gov.agency.msdrg.v400.chain.ProcessingContext;
import gov.agency.msdrg.v400.logic.marking.ProcedureMarking;
import gov.agency.msdrg.v400.model.MsdrgCode;
import gov.agency.msdrg.v400.model.MsdrgDiagnosisCode;
import gov.agency.msdrg.v400.model.MsdrgProcedureCode;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FinalProcedureMarking
extends ProcedureMarking
implements Link {
    @Override
    GroupingContext fetchGroupingContext(ProcessingContext context) {
        return context.getFinalGroupingContext();
    }

    @Override
    int fetchMdc(ProcessingContext context) {
        GroupingContext groupingContext = this.fetchGroupingContext(context);
        int mdc = groupingContext.getMatchRerouteMdc();
        if (mdc == 0) {
            mdc = context.getProcessingData().getPrincipalDx().getMdc();
        }
        if (this.unrelated(groupingContext.getMatch())) {
            mdc = 29;
        }
        return mdc;
    }

    @Override
    void setMarked(MsdrgProcedureCode code) {
        code.mark(MsdrgCode.CodeFlag.MARKED_FOR_FINAL);
    }

    @Override
    void setDrgImpact(MsdrgProcedureCode code) {
        code.setDrgImpact(this.impactMarking(code.getDrgImpact()));
    }

    @Override
    void hacMarking(ProcessingContext context) throws FoundationException {
        ProcessingData processingData = context.getProcessingData();
        int mdc = this.fetchMdc(context);
        List<MsdrgDiagnosisCode> sdxCodes = processingData.getSdxCodes();
        List<MsdrgProcedureCode> procCodes = processingData.getProcedureCodes();
        GroupingContext finalGroupingContext = context.getFinalGroupingContext();
        GroupingContext initialGroupingContext = context.getInitialGroupingContext();
        Set<Integer> allHacsMet = this.getAllHacNumbersWhereCriteriaIsMet(sdxCodes);
        for (MsdrgProcedureCode procCode : procCodes) {
            if (procCode.getHacUsageFlag().isEmpty() || !finalGroupingContext.differentDrgs(initialGroupingContext) || procCode.getMdcSuppression().get(mdc)) continue;
            for (MsdrgProcedureHacUsage hac : procCode.getHacUsageFlag()) {
                if (!allHacsMet.contains(hac.getHacValue())) continue;
                this.setDrgImpact(procCode);
            }
        }
    }

    private Set<Integer> getAllHacNumbersWhereCriteriaIsMet(List<MsdrgDiagnosisCode> dxCodes) {
        HashSet<Integer> hacNumbers = new HashSet<Integer>();
        for (MsdrgDiagnosisCode dxCode : dxCodes) {
            if (dxCode.getHacs().isEmpty()) continue;
            for (MsdrgHac hac : dxCode.getHacs()) {
                if (hac.getHacStatus() != MsdrgHacUsage.HAC_CRITERIA_MET) continue;
                hacNumbers.add(hac.getHacNumber());
            }
        }
        return hacNumbers;
    }
}

